/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.hasor.db.jdbc.mapper.AbstractRowMapper;

public class SingleColumnRowMapper<T>
extends AbstractRowMapper<T> {
    private Class<T> requiredType;

    public SingleColumnRowMapper() {
    }

    public SingleColumnRowMapper(Class<T> requiredType) {
        this.requiredType = requiredType;
    }

    public void setRequiredType(Class<T> requiredType) {
        this.requiredType = requiredType;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new SQLException("Incorrect column count: expected 1, actual " + nrOfColumns);
        }
        Object result = SingleColumnRowMapper.getResultSetValue(rs, 1);
        if (this.requiredType != null && result != null && !this.requiredType.isInstance(result)) {
            result = SingleColumnRowMapper.convertValueToRequiredType(result, this.requiredType);
        }
        return (T)result;
    }
}

