/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.datasource;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import javax.sql.DataSource;
import net.hasor.db.datasource.CloseSuppressingInvocationHandler;
import net.hasor.db.datasource.ConnectionHolder;
import net.hasor.db.datasource.ConnectionProxy;

public class DataSourceManager {
    public static Connection newConnection(DataSource dataSource) {
        ConnectionHolder holder = DataSourceManager.newConnectionHolder(dataSource);
        return DataSourceManager.newProxyConnection(holder);
    }

    protected static ConnectionHolder newConnectionHolder(DataSource dataSource) {
        return new ConnectionHolder(dataSource);
    }

    protected static ConnectionProxy newProxyConnection(ConnectionHolder holder) {
        CloseSuppressingInvocationHandler handler = new CloseSuppressingInvocationHandler(holder);
        return (ConnectionProxy)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class, Closeable.class}, (InvocationHandler)handler);
    }
}

