/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;

public class ExceptionUtils {
    public static RuntimeException toRuntimeException(Throwable proxy) {
        return ExceptionUtils.toRuntimeException(proxy, throwable -> new RuntimeException(throwable.getClass().getName() + " - " + throwable.getMessage(), (Throwable)throwable));
    }

    public static RuntimeException toRuntimeException(Throwable proxy, Function<Throwable, RuntimeException> conver) {
        if (proxy instanceof InvocationTargetException && ((InvocationTargetException)proxy).getTargetException() != null) {
            proxy = ((InvocationTargetException)proxy).getTargetException();
        }
        if (proxy instanceof RuntimeException) {
            return (RuntimeException)proxy;
        }
        return conver.apply(proxy);
    }

    public static Throwable toRuntimeException(Throwable proxy, Class<?>[] exceptionTypes) {
        if (exceptionTypes != null) {
            for (Class<?> e : exceptionTypes) {
                if (!e.isInstance(exceptionTypes)) continue;
                return proxy;
            }
        }
        return new RuntimeException(proxy.getClass().getName() + " - " + proxy.getMessage(), proxy);
    }
}

