/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Mailer;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.web.pdf.PdfReport;

public class MailReport {
    public static void scheduleReportMailForLocalServer(Collector collector, Timer timer) {
        assert (collector != null);
        assert (timer != null);
        for (Period period : MailReport.getMailPeriods()) {
            MailReport.scheduleReportMailForLocalServer(collector, timer, period);
        }
    }

    static void scheduleReportMailForLocalServer(final Collector collector, final Timer timer, final Period period) {
        assert (collector != null);
        assert (timer != null);
        assert (period != null);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    new MailReport().sendReportMailForLocalServer(collector, period);
                }
                catch (Throwable t) {
                    LOG.warn("sending mail report failed", t);
                }
                MailReport.scheduleReportMailForLocalServer(collector, timer, period);
            }
        };
        Date nextExecutionDate = MailReport.getNextExecutionDate(period);
        timer.schedule(task, nextExecutionDate);
        LOG.debug("mail report for the " + period.getMailCode() + " period scheduled with next execution date at " + nextExecutionDate);
    }

    public static List<Period> getMailPeriods() {
        List<Period> mailPeriods;
        if (Parameter.MAIL_PERIODS.getValue() == null) {
            mailPeriods = Collections.singletonList(Period.SEMAINE);
        } else {
            String mailPeriodsParameter = Parameter.MAIL_PERIODS.getValue();
            mailPeriods = new ArrayList<Period>();
            for (String mailPeriod : mailPeriodsParameter.split(",")) {
                mailPeriods.add(Period.valueOfByMailCode(mailPeriod));
            }
        }
        return mailPeriods;
    }

    public static Date getNextExecutionDate(Period period) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (period) {
            case JOUR: {
                calendar.add(6, 1);
                break;
            }
            case SEMAINE: {
                calendar.set(7, 1);
                if (calendar.getTimeInMillis() >= System.currentTimeMillis()) break;
                calendar.add(6, 7);
                break;
            }
            case MOIS: {
                calendar.set(5, 1);
                if (calendar.getTimeInMillis() >= System.currentTimeMillis()) break;
                calendar.add(2, 1);
                break;
            }
            case ANNEE: {
                throw new IllegalArgumentException(String.valueOf((Object)period));
            }
            case TOUT: {
                throw new IllegalArgumentException(String.valueOf((Object)period));
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)period));
            }
        }
        return calendar.getTime();
    }

    public void sendReportMailForLocalServer(Collector collector, Period period) throws Exception {
        JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), true);
        this.sendReportMail(collector, false, Collections.singletonList(javaInformations), period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReportMail(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList, Period period) throws Exception {
        File tmpFile = new File(Parameters.TEMPORARY_DIRECTORY, PdfReport.getFileName(collector.getApplication()));
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(tmpFile));
            try {
                PdfReport pdfReport = new PdfReport(collector, collectorServer, javaInformationsList, period, (OutputStream)output);
                pdfReport.toPdf();
            }
            finally {
                ((OutputStream)output).close();
            }
            String subject = I18N.getFormattedString("Monitoring_sur", collector.getApplication()) + " - " + period.getLabel();
            Mailer mailer = new Mailer(Parameter.MAIL_SESSION.getValue());
            String adminEmails = Parameter.ADMIN_EMAILS.getValue();
            mailer.send(adminEmails, subject, "", Collections.singletonList(tmpFile), false);
        }
        finally {
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }
}

