/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.JobInformations;
import net.bull.javamelody.internal.model.QuartzAdapter;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.impl.matchers.GroupMatcher;

class Quartz2Adapter
extends QuartzAdapter {
    protected Quartz2Adapter() {
    }

    @Override
    String getJobName(JobDetail jobDetail) {
        return jobDetail.getKey().getName();
    }

    @Override
    String getJobGroup(JobDetail jobDetail) {
        return jobDetail.getKey().getGroup();
    }

    @Override
    public String getJobFullName(JobDetail jobDetail) {
        return this.getJobGroup(jobDetail) + '.' + this.getJobName(jobDetail);
    }

    @Override
    String getJobDescription(JobDetail jobDetail) {
        return jobDetail.getDescription();
    }

    @Override
    Class<?> getJobClass(JobDetail jobDetail) {
        return jobDetail.getJobClass();
    }

    @Override
    List<Date> getPreviousAndNextFireTime(List<Trigger> triggers) {
        return super.getPreviousAndNextFireTime(triggers);
    }

    @Override
    String getCronTriggerExpression(CronTrigger trigger) {
        return trigger.getCronExpression();
    }

    @Override
    long getSimpleTriggerRepeatInterval(SimpleTrigger trigger) {
        return trigger.getRepeatInterval();
    }

    @Override
    public JobDetail getContextJobDetail(JobExecutionContext context) {
        return context.getJobDetail();
    }

    @Override
    Date getContextFireTime(JobExecutionContext context) {
        return context.getFireTime();
    }

    @Override
    public void addGlobalJobListener(JobListener jobGlobalListener) throws SchedulerException {
        Scheduler defaultScheduler;
        ArrayList<EverythingMatcher> allJobs = new ArrayList<EverythingMatcher>();
        allJobs.add(EverythingMatcher.allJobs());
        if (Parameter.QUARTZ_DEFAULT_LISTENER_DISABLED.getValueAsBoolean()) {
            defaultScheduler = null;
            LOG.debug("Initialization of Quartz default listener has been disabled");
        } else {
            defaultScheduler = StdSchedulerFactory.getDefaultScheduler();
            defaultScheduler.getListenerManager().addJobListener(jobGlobalListener, allJobs);
        }
        for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
            if (scheduler == defaultScheduler) continue;
            scheduler.getListenerManager().addJobListener(jobGlobalListener, allJobs);
        }
    }

    @Override
    public void removeGlobalJobListener(Class<? extends JobListener> jobListenerClass) throws SchedulerException {
        for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
            ListenerManager listenerManager = scheduler.getListenerManager();
            List globalJobListeners = listenerManager.getJobListeners();
            for (JobListener jobListener : new ArrayList(globalJobListeners)) {
                if (!jobListenerClass.isInstance(jobListener)) continue;
                listenerManager.removeJobListener(jobListener.getName());
            }
        }
    }

    @Override
    List<JobDetail> getAllJobsOfScheduler(Scheduler scheduler) throws SchedulerException {
        ArrayList<JobDetail> result = new ArrayList<JobDetail>();
        for (String jobGroupName : scheduler.getJobGroupNames()) {
            GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)jobGroupName);
            for (JobKey jobKey : scheduler.getJobKeys(groupMatcher)) {
                try {
                    JobDetail jobDetail = scheduler.getJobDetail(jobKey);
                    if (jobDetail == null) continue;
                    result.add(jobDetail);
                }
                catch (Exception e) {
                    LOG.debug(e.toString(), e);
                }
            }
        }
        return result;
    }

    @Override
    List<Trigger> getTriggersOfJob(JobDetail jobDetail, Scheduler scheduler) throws SchedulerException {
        return scheduler.getTriggersOfJob(jobDetail.getKey());
    }

    @Override
    boolean isTriggerPaused(Trigger trigger, Scheduler scheduler) throws SchedulerException {
        return scheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED;
    }

    @Override
    void pauseJob(JobDetail jobDetail, Scheduler scheduler) throws SchedulerException {
        scheduler.pauseJob(jobDetail.getKey());
    }

    @Override
    void resumeJob(JobDetail jobDetail, Scheduler scheduler) throws SchedulerException {
        scheduler.resumeJob(jobDetail.getKey());
    }
}

