/*
 * Decompiled with CFR 0.152.
 */
package jna.service;

import com.sun.jna.Pointer;
import jna.BaseCallJNA;
import jna.common.SDKResult;
import jna.model.CameraBriefInfoList;
import jna.model.IndexRange;
import jna.service.IvsCommonService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryService {
    private static QueryService service = null;

    public static synchronized QueryService getInstance() {
        if (null == service) {
            service = new QueryService();
        }
        return service;
    }

    public synchronized SDKResult<CameraBriefInfoList> getDeviceList(int fromIndex, int toIndex) {
        SDKResult<CameraBriefInfoList> result = new SDKResult<CameraBriefInfoList>();
        IndexRange indexRange = new IndexRange();
        indexRange.clear();
        indexRange.fromIndex = fromIndex;
        indexRange.toIndex = toIndex;
        int size = toIndex - fromIndex + 1;
        if (1 > size) {
            size = 1;
        }
        CameraBriefInfoList cameraBriefInfoList = new CameraBriefInfoList(1000);
        cameraBriefInfoList.clear();
        Pointer pointer = cameraBriefInfoList.getPointer();
        int sessionid = IvsCommonService.getSESSIONID();
        int resultCode = BaseCallJNA.INSTANCE.IVS_SDK_GetDeviceList(sessionid, 2, indexRange, pointer, size * 980 + 12);
        cameraBriefInfoList.read();
        result.setErrCode((long)resultCode);
        if (0 == resultCode) {
            result.setResult(cameraBriefInfoList);
        }
        return result;
    }
}

