/*
 * Decompiled with CFR 0.152.
 */
package jna.service;

import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import jna.BaseCallJNA;
import jna.common.ControlCode;
import jna.common.DeviceInfo;
import jna.common.SDKErrorCode;
import jna.common.SDKResult;
import jna.model.CameraBriefInfo;
import jna.model.CameraBriefInfoList;
import jna.model.IndexRange;
import jna.model.LoginInfo;
import jna.model.PtzAbsposition;
import jna.model.SnapshotInfoList;
import jna.model.SnapshotParam;
import jna.model.TimeSpan;
import jna.service.QueryService;
import jna.util.StringUtil;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvsCommonService {
    private static final Logger LOGGER = Logger.getLogger(IvsCommonService.class);
    private static int SESSIONID = -1;
    private static IvsCommonService service = null;

    private IvsCommonService() {
    }

    public static synchronized IvsCommonService getInstance() {
        if (null == service) {
            service = new IvsCommonService();
        }
        return service;
    }

    public static int getSESSIONID() {
        return SESSIONID;
    }

    private static void setSESSIONID(int sessionId) {
        SESSIONID = sessionId;
    }

    public SDKErrorCode setLogPath(String path) {
        LOGGER.info((Object)"setLogPath start --->>> ");
        SDKErrorCode result = new SDKErrorCode();
        int resultCode = BaseCallJNA.INSTANCE.IVS_SDK_SetLogPath(path);
        result.setErrCode((long)resultCode);
        LOGGER.info((Object)("setLogPath result code: " + resultCode));
        LOGGER.info((Object)"setLogPath end --->>> ");
        return result;
    }

    public SDKErrorCode init() {
        LOGGER.info((Object)"init start --->>> ");
        SDKErrorCode result = new SDKErrorCode();
        int resultCode = BaseCallJNA.INSTANCE.IVS_SDK_Init();
        result.setErrCode((long)resultCode);
        LOGGER.info((Object)("init result code: " + resultCode));
        LOGGER.info((Object)"init end --->>> ");
        return result;
    }

    public SDKErrorCode cleanup() {
        LOGGER.info((Object)"cleanup start --->>> ");
        SDKErrorCode result = new SDKErrorCode();
        int resultCode = BaseCallJNA.INSTANCE.IVS_SDK_Cleanup();
        result.setErrCode((long)resultCode);
        LOGGER.info((Object)("cleanup result code: " + resultCode));
        LOGGER.info((Object)"cleanup end --->>> ");
        return result;
    }

    public int doConnection(String userName, String password, String ip, String port) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.clear();
        loginInfo.userName = StringUtil.getNativeBytes(userName);
        loginInfo.password = StringUtil.getNativeBytes(password);
        loginInfo.port = Integer.valueOf(port);
        loginInfo.ipInfo.ip = StringUtil.getNativeBytes(ip);
        loginInfo.ipInfo.ipType = 0;
        loginInfo.clientType = 0;
        loginInfo.loginType = 0;
        IntByReference ref = new IntByReference();
        int resultCode = BaseCallJNA.INSTANCE.IVS_SDK_Login(loginInfo, (ByReference)ref);
        LOGGER.info((Object)("login result code: " + resultCode));
        if (0 == resultCode) {
            IvsCommonService.setSESSIONID(ref.getValue());
        }
        return resultCode;
    }

    public int destroyConnection() {
        LOGGER.info((Object)"destroy connection start");
        int result = 1;
        if (-1 != IvsCommonService.getSESSIONID()) {
            result = BaseCallJNA.INSTANCE.IVS_SDK_Logout(IvsCommonService.getSESSIONID());
        }
        if (0 == result) {
            LOGGER.info((Object)"destroy connection success");
            IvsCommonService.setSESSIONID(-1);
        } else {
            LOGGER.error((Object)"destroy connection failed");
        }
        LOGGER.info((Object)"destroy connection end");
        return result;
    }

    public List<DeviceInfo> getDeviceList() throws UnsatisfiedLinkError {
        QueryService queryService = QueryService.getInstance();
        ArrayList<DeviceInfo> deviceInfoArrayList = new ArrayList<DeviceInfo>();
        SDKResult<CameraBriefInfoList> infoList = queryService.getDeviceList(1, 1);
        if (0L != infoList.getErrCode()) {
            LOGGER.error((Object)("Get First DeviceList Failed, resultCode:" + infoList.getErrCode()));
            return null;
        }
        LOGGER.info((Object)("get First DeviceList success, total:" + infoList.getResult().total));
        infoList = queryService.getDeviceList(1, infoList.getResult().total > 1000 ? 1000 : infoList.getResult().total);
        if (0L != infoList.getErrCode()) {
            LOGGER.error((Object)("Get All DeviceList Failed, resultCode:" + infoList.getErrCode()));
            return null;
        }
        for (int i = infoList.getResult().indexRange.fromIndex - 1; i < infoList.getResult().indexRange.toIndex; ++i) {
            String deviceModelType;
            String vendorType;
            String name;
            String code;
            CameraBriefInfo info = infoList.getResult().cameraBriefInfo[i];
            try {
                code = new String(StringUtil.trimByteArray(info.code), "GBK");
                name = new String(StringUtil.trimByteArray(info.name), "GBK");
                vendorType = new String(StringUtil.trimByteArray(info.vendorType), "GBK");
                deviceModelType = new String(StringUtil.trimByteArray(info.deviceModelType), "GBK");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)"Process DeviceList Info Failed:", (Throwable)e);
                return null;
            }
            LOGGER.debug((Object)(code + "\t" + info.status + "\t" + info.type + "\t" + vendorType + "\t\t" + deviceModelType + "\t\t" + name));
            if (null == code || null == name) continue;
            DeviceInfo deviceInfo = new DeviceInfo(code, name, info.type, info.status);
            deviceInfo.setVendorType(vendorType);
            deviceInfo.setDeviceModelType(deviceModelType);
            deviceInfoArrayList.add(deviceInfo);
        }
        return deviceInfoArrayList;
    }

    public int ptzControl(String cameraCode, ControlCode controlCode, String param1, String param2, int lockStatus) {
        LOGGER.info((Object)"ptz control start");
        int resultCode = BaseCallJNA.INSTANCE.IVS_SDK_PtzControl(IvsCommonService.getSESSIONID(), StringUtil.getNativeBytes(cameraCode, 64), controlCode.ordinal() + 1, param1, param2, (ByReference)new IntByReference(lockStatus));
        LOGGER.info((Object)"ptz control end");
        return resultCode;
    }

    public PtzAbsposition getPtzAbsPosition(String domainCode, String cameraCode) {
        LOGGER.info((Object)"get ptzAbsPosition start");
        PtzAbsposition ptzAbsposition = new PtzAbsposition();
        int resultCode = BaseCallJNA.INSTANCE.IVS_SDK_GetPTZAbsPosition(IvsCommonService.getSESSIONID(), StringUtil.getNativeBytes(domainCode), StringUtil.getNativeBytes(cameraCode), ptzAbsposition);
        ptzAbsposition.read();
        if (resultCode != 0) {
            LOGGER.error((Object)("get ptzAbsPosition failed,errorCode:" + resultCode));
        } else {
            LOGGER.info((Object)"get ptzAbsPosition end");
        }
        return ptzAbsposition;
    }

    public int platformSnapshot(String cameraCode) {
        LOGGER.info((Object)"platform snapshot start");
        int resultCode = BaseCallJNA.INSTANCE.IVS_SDK_PlatformSnapshot(IvsCommonService.getSESSIONID(), StringUtil.getNativeBytes(cameraCode));
        LOGGER.info((Object)"platform snapshot end");
        return resultCode;
    }

    public SnapshotInfoList getSnapshotList(String cameraCode, int fromIndex, int toIndex, int snapType, String start, String end) {
        SnapshotParam snapshotParam = new SnapshotParam();
        snapshotParam.snapType = snapType;
        snapshotParam.indexRange = new IndexRange();
        snapshotParam.indexRange.fromIndex = fromIndex;
        snapshotParam.indexRange.toIndex = toIndex;
        int size = toIndex - fromIndex + 1;
        if (1 > size) {
            size = 1;
        }
        snapshotParam.timeSpan = new TimeSpan();
        snapshotParam.timeSpan.start = StringUtil.getNativeBytes(start);
        snapshotParam.timeSpan.end = StringUtil.getNativeBytes(end);
        SnapshotInfoList snapshotInfoList = new SnapshotInfoList(size);
        LOGGER.info((Object)"get snapshot list start");
        int resultCode = BaseCallJNA.INSTANCE.IVS_SDK_GetSnapshotList(IvsCommonService.getSESSIONID(), cameraCode, snapshotParam, snapshotInfoList.getPointer(), size * 980 + 12);
        if (resultCode != 0) {
            LOGGER.error((Object)("get snapshot list failed,errorCode:" + resultCode));
        } else {
            LOGGER.info((Object)"get snapshot list end");
        }
        snapshotInfoList.read();
        return snapshotInfoList;
    }
}

