/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.range;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.utilities.ImageUtilities;

public class RangeFloat
extends Range {
    public static RangeFloat FULL_RANGE = new RangeFloat(Float.NEGATIVE_INFINITY, true, Float.POSITIVE_INFINITY, true, true);
    private final float minValue;
    private final float maxValue;
    private final int intValue;
    private final boolean isPoint;
    private final boolean isNaN;
    private final boolean nanIncluded;

    RangeFloat(float minValue, boolean minIncluded, float maxValue, boolean maxIncluded, boolean nanIncluded) {
        super(minIncluded, maxIncluded);
        if (Float.isNaN(minValue) && !Float.isNaN(maxValue) || !Float.isNaN(minValue) && Float.isNaN(maxValue)) {
            throw new UnsupportedOperationException("NaN values can only be set inside a single-point Range");
        }
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.isPoint = false;
            this.isNaN = false;
            this.intValue = 0;
            this.nanIncluded = nanIncluded;
        } else if (minValue > maxValue) {
            this.minValue = maxValue;
            this.maxValue = minValue;
            this.isPoint = false;
            this.isNaN = false;
            this.intValue = 0;
            this.nanIncluded = nanIncluded;
        } else {
            this.minValue = minValue;
            this.maxValue = minValue;
            this.isPoint = true;
            this.nanIncluded = false;
            if (Float.isNaN(minValue)) {
                this.isNaN = true;
                this.intValue = Float.floatToIntBits(minValue);
            } else {
                this.isNaN = false;
                this.intValue = 0;
            }
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.setMaxIncluded(true);
            this.setMinIncluded(true);
        }
    }

    @Override
    public boolean contains(float value) {
        boolean notLower;
        if (this.isPoint) {
            if (this.isNaN) {
                int valueInt = Float.floatToIntBits(value);
                return valueInt == this.intValue;
            }
            return this.minValue == value;
        }
        if (this.nanIncluded) {
            boolean lower;
            if (this.isMinIncluded()) {
                lower = value < this.minValue;
            } else {
                boolean bl = lower = value <= this.minValue;
            }
            boolean upper = this.isMaxIncluded() ? value > this.maxValue : value >= this.maxValue;
            return !lower && !upper;
        }
        if (this.isMinIncluded()) {
            notLower = value >= this.minValue;
        } else {
            boolean bl = notLower = value > this.minValue;
        }
        boolean notUpper = this.isMaxIncluded() ? value <= this.maxValue : value < this.maxValue;
        return notLower && notUpper;
    }

    @Override
    public Range.DataType getDataType() {
        return Range.DataType.FLOAT;
    }

    @Override
    public boolean isPoint() {
        return this.isPoint;
    }

    @Override
    public Number getMax() {
        return Float.valueOf(this.maxValue);
    }

    @Override
    public Number getMin() {
        return Float.valueOf(this.minValue);
    }

    @Override
    public Number getMax(boolean isMaxIncluded) {
        float value = this.maxValue;
        if (isMaxIncluded != this.isMaxIncluded()) {
            value = (float)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMaxIncluded ? -1 : 1);
        }
        return Float.valueOf(value);
    }

    @Override
    public Number getMin(boolean isMinIncluded) {
        float value = this.minValue;
        if (isMinIncluded != this.isMinIncluded()) {
            value = (float)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMinIncluded ? -1 : 1);
        }
        return Float.valueOf(value);
    }

    @Override
    public boolean isNanIncluded() {
        return this.nanIncluded;
    }

    @Override
    public boolean isNaN() {
        return this.isNaN;
    }

    @Override
    public Range union(Range other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        float min2 = other.getMin().floatValue();
        float max2 = other.getMax().floatValue();
        float finalMin = this.minValue;
        float finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (min2 < this.minValue) {
            finalMin = min2;
            minIncluded = other.isMinIncluded();
        } else if (min2 == this.minValue) {
            minIncluded |= other.isMinIncluded();
        }
        if (max2 > this.maxValue) {
            finalMax = max2;
            maxIncluded = other.isMaxIncluded();
        } else if (max2 == this.maxValue) {
            maxIncluded |= other.isMaxIncluded();
        }
        boolean isNaNIncluded = this.isNaN() || other.isNaN() || this.isNanIncluded() || other.isNanIncluded();
        return new RangeFloat(finalMin, minIncluded, finalMax, maxIncluded, isNaNIncluded);
    }

    @Override
    public Range intersection(Range other) {
        if (other.getDataType() == this.getDataType()) {
            if (other.contains(this)) {
                return this;
            }
            if (this.contains(other)) {
                return other;
            }
        }
        float minOther = other.getMin().floatValue();
        float maxOther = other.getMax().floatValue();
        if (Float.isNaN(minOther) && Float.isNaN(maxOther)) {
            return new RangeFloat(minOther, other.isMinIncluded, maxOther, other.isMaxIncluded, other.isNanIncluded());
        }
        float finalMin = this.minValue;
        float finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (minOther > this.minValue) {
            finalMin = minOther;
            minIncluded = other.isMinIncluded();
        } else if (minOther == this.minValue) {
            minIncluded &= other.isMinIncluded();
        }
        if (maxOther < this.maxValue) {
            finalMax = maxOther;
            maxIncluded = other.isMaxIncluded();
        } else if (maxOther == this.maxValue) {
            maxIncluded &= other.isMaxIncluded();
        }
        if (finalMax < finalMin || finalMax == finalMin && !minIncluded && !maxIncluded) {
            return null;
        }
        boolean isNaNIncluded = this.isNaN() && other.isNaN() && this.isNanIncluded() && other.isNanIncluded();
        return new RangeFloat(finalMin, minIncluded, finalMax, maxIncluded, isNaNIncluded);
    }
}

