/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser;

import it.geosolutions.jaiext.jiffle.parser.AbstractModelWorker;
import it.geosolutions.jaiext.jiffle.parser.GlobalScope;
import it.geosolutions.jaiext.jiffle.parser.InternalCompilerException;
import it.geosolutions.jaiext.jiffle.parser.JiffleParser;
import it.geosolutions.jaiext.jiffle.parser.JiffleType;
import it.geosolutions.jaiext.jiffle.parser.Symbol;
import it.geosolutions.jaiext.jiffle.parser.SymbolScope;
import it.geosolutions.jaiext.jiffle.parser.TreeNodeProperties;
import it.geosolutions.jaiext.jiffle.parser.node.BinaryExpression;
import it.geosolutions.jaiext.jiffle.parser.node.Break;
import it.geosolutions.jaiext.jiffle.parser.node.BreakIf;
import it.geosolutions.jaiext.jiffle.parser.node.DefaultScalarValue;
import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.GlobalVars;
import it.geosolutions.jaiext.jiffle.parser.node.IfElse;
import it.geosolutions.jaiext.jiffle.parser.node.ListAppend;
import it.geosolutions.jaiext.jiffle.parser.node.ListLiteral;
import it.geosolutions.jaiext.jiffle.parser.node.LoopInLiteralList;
import it.geosolutions.jaiext.jiffle.parser.node.LoopInRange;
import it.geosolutions.jaiext.jiffle.parser.node.LoopInVariable;
import it.geosolutions.jaiext.jiffle.parser.node.NodeException;
import it.geosolutions.jaiext.jiffle.parser.node.Script;
import it.geosolutions.jaiext.jiffle.parser.node.SetDestValue;
import it.geosolutions.jaiext.jiffle.parser.node.SimpleStatement;
import it.geosolutions.jaiext.jiffle.parser.node.Statement;
import it.geosolutions.jaiext.jiffle.parser.node.StatementList;
import it.geosolutions.jaiext.jiffle.parser.node.Until;
import it.geosolutions.jaiext.jiffle.parser.node.Variable;
import it.geosolutions.jaiext.jiffle.parser.node.While;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;

public class RuntimeModelWorker
extends AbstractModelWorker {
    private final TreeNodeProperties<JiffleType> types;
    private final TreeNodeProperties<SymbolScope> scopes;
    private final Map<String, String> options;
    private final Set<VariableKey> declaredVariables = new HashSet<VariableKey>();
    private JiffleParser.InitBlockContext initBlockContext = null;
    private Script script;

    public RuntimeModelWorker(ParseTree tree, Map<String, String> options, TreeNodeProperties<JiffleType> types, TreeNodeProperties<SymbolScope> scopes) {
        super(tree);
        this.types = types;
        this.scopes = scopes;
        this.options = options;
        this.walkTree();
    }

    @Override
    public void exitScript(JiffleParser.ScriptContext ctx) {
        StatementList stmts = this.getAsType((ParseTree)ctx.body(), StatementList.class);
        GlobalVars globals = this.initBlockContext == null ? new GlobalVars() : this.getAsType((ParseTree)this.initBlockContext, GlobalVars.class);
        GlobalScope globalScope = (GlobalScope)this.scopes.get((ParseTree)ctx);
        Set<String> sourceImages = globalScope.getByType(Symbol.Type.SOURCE_IMAGE);
        Set<String> destImages = globalScope.getByType(Symbol.Type.DEST_IMAGE);
        this.script = new Script(this.options, sourceImages, destImages, globals, stmts);
        this.set((ParseTree)ctx, this.script);
    }

    @Override
    public void exitBody(JiffleParser.BodyContext ctx) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (JiffleParser.StatementContext sctx : ctx.statement()) {
            statements.add(this.getAsType((ParseTree)sctx, Statement.class));
        }
        this.set((ParseTree)ctx, new StatementList(statements));
    }

    @Override
    public void exitInitBlock(JiffleParser.InitBlockContext ctx) {
        ArrayList<BinaryExpression> inits = new ArrayList<BinaryExpression>();
        List<JiffleParser.VarDeclarationContext> decls = ctx.varDeclaration();
        if (decls != null) {
            try {
                for (JiffleParser.VarDeclarationContext dc : decls) {
                    String name = dc.ID().getText();
                    JiffleParser.ExpressionContext exprCtx = dc.expression();
                    Expression value = exprCtx == null ? new DefaultScalarValue() : this.getAsType((ParseTree)exprCtx, Expression.class);
                    inits.add(new BinaryExpression(50, new Variable(name, JiffleType.D), value));
                }
            }
            catch (NodeException ex) {
                this.messages.error(ctx.getStart(), ex.getError());
            }
        }
        this.set((ParseTree)ctx, new GlobalVars(inits));
        this.initBlockContext = ctx;
    }

    @Override
    public void exitExprStmt(JiffleParser.ExprStmtContext ctx) {
        this.set((ParseTree)ctx, new SimpleStatement(this.getAsType((ParseTree)ctx.expression(), Expression.class)));
    }

    @Override
    public void exitExpressionList(JiffleParser.ExpressionListContext ctx) {
    }

    @Override
    public void exitAssignExpr(JiffleParser.AssignExprContext ctx) {
        this.set((ParseTree)ctx, this.get((ParseTree)ctx.assignment()));
    }

    @Override
    public void exitAssignment(JiffleParser.AssignmentContext ctx) {
        String varName = ctx.ID().getText();
        SymbolScope scope = this.getScope((ParseTree)ctx);
        Symbol symbol = scope.get(varName);
        SymbolScope declaringScope = scope.getDeclaringScope(varName);
        boolean declare = this.checkAndSetDeclared(declaringScope, varName);
        int opType = ctx.op.getType();
        Expression expr = this.getAsType((ParseTree)ctx.expression(), Expression.class);
        try {
            switch (symbol.getType()) {
                case DEST_IMAGE: {
                    this.set((ParseTree)ctx, new SetDestValue(varName, expr));
                    break;
                }
                case LIST: {
                    this.set((ParseTree)ctx, new BinaryExpression(opType, new Variable(varName, JiffleType.LIST), expr, declare));
                    break;
                }
                case SCALAR: {
                    this.set((ParseTree)ctx, new BinaryExpression(opType, new Variable(varName, JiffleType.D), expr, declare));
                    break;
                }
                default: {
                    throw new InternalCompilerException("Invalid assignment to " + varName);
                }
            }
        }
        catch (NodeException ex) {
            this.messages.error(ctx.getStart(), ex.getError());
        }
    }

    private boolean checkAndSetDeclared(SymbolScope scope, String varName) {
        if (scope instanceof GlobalScope) {
            return false;
        }
        return this.declaredVariables.add(new VariableKey(scope, varName));
    }

    @Override
    protected SymbolScope getScope(ParseTree ctx) {
        if (ctx != null) {
            SymbolScope s = (SymbolScope)this.scopes.get(ctx);
            return s != null ? s : this.getScope(ctx.getParent());
        }
        throw new IllegalStateException("Compiler error: failed to find symbol scope");
    }

    @Override
    public void exitUntilStmt(JiffleParser.UntilStmtContext ctx) {
        Expression condition = this.getAsType((ParseTree)ctx.parenExpression().expression(), Expression.class);
        Statement statement = this.getAsType((ParseTree)ctx.statement(), Statement.class);
        this.set((ParseTree)ctx, new Until(condition, statement));
    }

    @Override
    public void exitBreakifStmt(JiffleParser.BreakifStmtContext ctx) {
        Expression condition = this.getAsType((ParseTree)ctx.expression(), Expression.class);
        this.set((ParseTree)ctx, new BreakIf(condition));
    }

    @Override
    public void exitBlock(JiffleParser.BlockContext ctx) {
        List<JiffleParser.StatementContext> contexts = ctx.statement();
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (JiffleParser.StatementContext context : contexts) {
            Statement st = this.getAsType((ParseTree)context, Statement.class);
            statements.add(st);
        }
        this.set((ParseTree)ctx, new StatementList(statements));
    }

    @Override
    public void exitBlockStmt(JiffleParser.BlockStmtContext ctx) {
        this.set((ParseTree)ctx, this.get((ParseTree)ctx.block()));
    }

    public Script getScriptNode() {
        return this.script;
    }

    @Override
    public void exitIfStmt(JiffleParser.IfStmtContext ctx) {
        Expression condition = this.getAsType((ParseTree)ctx.parenExpression().expression(), Expression.class);
        List<JiffleParser.StatementContext> statements = ctx.statement();
        Statement ifBlock = this.getAsType((ParseTree)statements.get(0), Statement.class);
        Statement elseBlock = null;
        if (statements.size() > 1) {
            elseBlock = this.getAsType((ParseTree)statements.get(1), Statement.class);
        }
        this.set((ParseTree)ctx, new IfElse(condition, ifBlock, elseBlock));
    }

    @Override
    public void exitListAppendStmt(JiffleParser.ListAppendStmtContext ctx) {
        String varName = ctx.ID().getText();
        Expression expression = this.getAsType((ParseTree)ctx.expression(), Expression.class);
        this.set((ParseTree)ctx, new ListAppend(new Variable(varName, JiffleType.LIST), expression));
    }

    @Override
    public void exitForeachStmt(JiffleParser.ForeachStmtContext ctx) {
        String varName = ctx.ID().getText();
        JiffleParser.RangeContext range = ctx.loopSet().range();
        Variable loopVariable = new Variable(varName, JiffleType.D);
        Statement statement = this.getAsType((ParseTree)ctx.statement(), Statement.class);
        if (ctx.loopSet().ID() != null) {
            Variable listVariable = new Variable(ctx.loopSet().ID().getText(), JiffleType.LIST);
            this.set((ParseTree)ctx, new LoopInVariable(loopVariable, listVariable, statement));
        } else if (range != null) {
            Expression low = this.getAsType((ParseTree)range.expression(0), Expression.class);
            Expression high = this.getAsType((ParseTree)range.expression(1), Expression.class);
            this.set((ParseTree)ctx, new LoopInRange(loopVariable, low, high, statement));
        } else {
            ListLiteral listLiteral = this.getAsType((ParseTree)ctx.loopSet().listLiteral(), ListLiteral.class);
            this.set((ParseTree)ctx, new LoopInLiteralList(loopVariable, listLiteral, statement));
        }
    }

    @Override
    public void exitBreakStmt(JiffleParser.BreakStmtContext ctx) {
        this.set((ParseTree)ctx, new Break());
    }

    @Override
    public void exitWhileStmt(JiffleParser.WhileStmtContext ctx) {
        Expression condition = this.getAsType((ParseTree)ctx.parenExpression().expression(), Expression.class);
        Statement statement = this.getAsType((ParseTree)ctx.statement(), Statement.class);
        this.set((ParseTree)ctx, new While(condition, statement));
    }

    private static class VariableKey {
        SymbolScope scope;
        String name;

        public VariableKey(SymbolScope scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariableKey that = (VariableKey)o;
            return Objects.equals(this.scope, that.scope) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.scope, this.name);
        }
    }
}

