/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser;

import it.geosolutions.jaiext.jiffle.parser.ConstantLookup;
import it.geosolutions.jaiext.jiffle.parser.InternalCompilerException;
import it.geosolutions.jaiext.jiffle.parser.JiffleParser;
import it.geosolutions.jaiext.jiffle.parser.JiffleParserException;
import it.geosolutions.jaiext.jiffle.parser.JiffleType;
import it.geosolutions.jaiext.jiffle.parser.PropertyWorker;
import it.geosolutions.jaiext.jiffle.parser.RepeatedReadOptimizer;
import it.geosolutions.jaiext.jiffle.parser.Symbol;
import it.geosolutions.jaiext.jiffle.parser.SymbolScope;
import it.geosolutions.jaiext.jiffle.parser.node.Band;
import it.geosolutions.jaiext.jiffle.parser.node.BinaryExpression;
import it.geosolutions.jaiext.jiffle.parser.node.ConFunction;
import it.geosolutions.jaiext.jiffle.parser.node.ConstantLiteral;
import it.geosolutions.jaiext.jiffle.parser.node.DoubleLiteral;
import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.FunctionCall;
import it.geosolutions.jaiext.jiffle.parser.node.GetSourceValue;
import it.geosolutions.jaiext.jiffle.parser.node.ImagePos;
import it.geosolutions.jaiext.jiffle.parser.node.IntLiteral;
import it.geosolutions.jaiext.jiffle.parser.node.ListLiteral;
import it.geosolutions.jaiext.jiffle.parser.node.Node;
import it.geosolutions.jaiext.jiffle.parser.node.NodeException;
import it.geosolutions.jaiext.jiffle.parser.node.ParenExpression;
import it.geosolutions.jaiext.jiffle.parser.node.Pixel;
import it.geosolutions.jaiext.jiffle.parser.node.PostfixUnaryExpression;
import it.geosolutions.jaiext.jiffle.parser.node.PrefixUnaryExpression;
import it.geosolutions.jaiext.jiffle.parser.node.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

abstract class AbstractModelWorker
extends PropertyWorker<Node> {
    protected RepeatedReadOptimizer readsOptimizer = new RepeatedReadOptimizer();

    public AbstractModelWorker(ParseTree tree) {
        super(tree);
    }

    @Override
    public void exitAtomExpr(JiffleParser.AtomExprContext ctx) {
        this.set((ParseTree)ctx, this.get((ParseTree)ctx.atom()));
    }

    @Override
    public void exitPowExpr(JiffleParser.PowExprContext ctx) {
        Expression a = this.getAsType((ParseTree)ctx.expression(0), Expression.class);
        Expression b = this.getAsType((ParseTree)ctx.expression(1), Expression.class);
        try {
            this.set((ParseTree)ctx, new BinaryExpression(28, a, b));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException();
        }
    }

    @Override
    public void exitPostExpr(JiffleParser.PostExprContext ctx) {
        String op = ctx.getChild(1).getText();
        Expression e = this.getAsType((ParseTree)ctx.expression(), Expression.class);
        this.set((ParseTree)ctx, new PostfixUnaryExpression(e, op));
    }

    @Override
    public void exitPreExpr(JiffleParser.PreExprContext ctx) {
        String op = ctx.getChild(0).getText();
        Expression e = this.getAsType((ParseTree)ctx.expression(), Expression.class);
        this.set((ParseTree)ctx, new PrefixUnaryExpression(op, e));
    }

    @Override
    public void exitNotExpr(JiffleParser.NotExprContext ctx) {
        this.setFunctionCall((ParseTree)ctx, "NOT", Collections.singletonList(ctx.expression()));
    }

    @Override
    public void exitTimesDivModExpr(JiffleParser.TimesDivModExprContext ctx) {
        Expression left = this.getAsType((ParseTree)ctx.expression(0), Expression.class);
        Expression right = this.getAsType((ParseTree)ctx.expression(1), Expression.class);
        try {
            this.set((ParseTree)ctx, new BinaryExpression(ctx.op.getType(), left, right));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException();
        }
    }

    @Override
    public void exitPlusMinusExpr(JiffleParser.PlusMinusExprContext ctx) {
        Expression left = this.getAsType((ParseTree)ctx.expression(0), Expression.class);
        Expression right = this.getAsType((ParseTree)ctx.expression(1), Expression.class);
        try {
            this.set((ParseTree)ctx, new BinaryExpression(ctx.op.getType(), left, right));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException();
        }
    }

    @Override
    public void exitCompareExpr(JiffleParser.CompareExprContext ctx) {
        String op;
        switch (ctx.op.getType()) {
            case 38: {
                op = "LT";
                break;
            }
            case 37: {
                op = "LE";
                break;
            }
            case 36: {
                op = "GE";
                break;
            }
            case 35: {
                op = "GT";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown op: " + ctx.op.getText());
            }
        }
        this.setFunctionCall((ParseTree)ctx, op, ctx.expression());
    }

    @Override
    public void exitEqExpr(JiffleParser.EqExprContext ctx) {
        String op;
        switch (ctx.op.getType()) {
            case 39: {
                op = "EQ";
                break;
            }
            case 40: {
                op = "NE";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown op: " + ctx.op.getText());
            }
        }
        this.setFunctionCall((ParseTree)ctx, op, ctx.expression());
    }

    @Override
    public void exitAndExpr(JiffleParser.AndExprContext ctx) {
        this.setFunctionCall((ParseTree)ctx, "AND", ctx.expression());
    }

    @Override
    public void exitOrExpr(JiffleParser.OrExprContext ctx) {
        this.setFunctionCall((ParseTree)ctx, "OR", ctx.expression());
    }

    @Override
    public void exitXorExpr(JiffleParser.XorExprContext ctx) {
        this.setFunctionCall((ParseTree)ctx, "XOR", ctx.expression());
    }

    private void setFunctionCall(ParseTree ctx, String fnName, List<JiffleParser.ExpressionContext> ecs) {
        try {
            this.set(ctx, FunctionCall.of(fnName, this.asExpressions(ecs)));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException();
        }
    }

    @Override
    public void exitTernaryExpr(JiffleParser.TernaryExprContext ctx) {
        Expression[] args = new Expression[]{this.getAsType((ParseTree)ctx.expression(0), Expression.class), this.getAsType((ParseTree)ctx.expression(1), Expression.class), this.getAsType((ParseTree)ctx.expression(2), Expression.class)};
        try {
            this.set((ParseTree)ctx, new ConFunction(args));
        }
        catch (NodeException ex) {
            this.messages.error(ctx.getStart(), ex.getError());
        }
    }

    @Override
    public void exitAtom(JiffleParser.AtomContext ctx) {
        this.set((ParseTree)ctx, this.get(ctx.getChild(0)));
    }

    @Override
    public void exitFunctionCall(JiffleParser.FunctionCallContext ctx) {
        JiffleParser.ExpressionListContext expressionList = ctx.argumentList().expressionList();
        if (expressionList == null) {
            this.setFunctionCall((ParseTree)ctx, ctx.start.getText(), new ArrayList<JiffleParser.ExpressionContext>());
        } else {
            this.setFunctionCall((ParseTree)ctx, ctx.start.getText(), expressionList.expression());
        }
    }

    @Override
    public void exitConCall(JiffleParser.ConCallContext ctx) {
        List<JiffleParser.ExpressionContext> es = ctx.argumentList().expressionList().expression();
        Expression[] args = new Expression[es.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.getAsType((ParseTree)es.get(i), Expression.class);
        }
        try {
            this.set((ParseTree)ctx, new ConFunction(args));
        }
        catch (NodeException ex) {
            this.messages.error(ctx.getStart(), ex.getError());
        }
    }

    @Override
    public void exitParenExpression(JiffleParser.ParenExpressionContext ctx) {
        Expression e = this.getAsType((ParseTree)ctx.expression(), Expression.class);
        this.set((ParseTree)ctx, new ParenExpression(e));
    }

    @Override
    public void exitImageCall(JiffleParser.ImageCallContext ctx) {
        String name = ctx.ID().getText();
        ImagePos pos = this.getAsType((ParseTree)ctx.imagePos(), ImagePos.class);
        GetSourceValue node = new GetSourceValue(name, pos);
        this.readsOptimizer.add(node);
        this.set((ParseTree)ctx, node);
    }

    @Override
    public void exitImagePos(JiffleParser.ImagePosContext ctx) {
        JiffleParser.BandSpecifierContext bandCtx = ctx.bandSpecifier();
        Band band = bandCtx == null ? Band.DEFAULT : this.getAsType((ParseTree)bandCtx, Band.class);
        JiffleParser.PixelSpecifierContext pixelCtx = ctx.pixelSpecifier();
        Pixel pixel = pixelCtx == null ? Pixel.DEFAULT : this.getAsType((ParseTree)pixelCtx, Pixel.class);
        this.set((ParseTree)ctx, new ImagePos(band, pixel));
    }

    @Override
    public void exitBandSpecifier(JiffleParser.BandSpecifierContext ctx) {
        Expression e = this.getAsType((ParseTree)ctx.expression(), Expression.class);
        this.set((ParseTree)ctx, new Band(e));
    }

    @Override
    public void exitPixelSpecifier(JiffleParser.PixelSpecifierContext ctx) {
        try {
            JiffleParser.PixelPosContext xpos = ctx.pixelPos(0);
            Expression e = this.getAsType((ParseTree)xpos.expression(), Expression.class);
            Expression x = xpos.ABS_POS_PREFIX() == null ? new BinaryExpression(32, FunctionCall.of("x", new Expression[0]), e) : e;
            JiffleParser.PixelPosContext ypos = ctx.pixelPos(1);
            e = this.getAsType((ParseTree)ypos.expression(), Expression.class);
            Expression y = ypos.ABS_POS_PREFIX() == null ? new BinaryExpression(32, FunctionCall.of("y", new Expression[0]), e) : e;
            this.set((ParseTree)ctx, new Pixel(x, y));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException(ex.getError().toString());
        }
    }

    @Override
    public void exitVarID(JiffleParser.VarIDContext ctx) {
        String name = ctx.ID().getText();
        if (ConstantLookup.isDefined(name)) {
            this.set((ParseTree)ctx, new DoubleLiteral(Double.toString(ConstantLookup.getValue(name))));
        } else {
            Symbol symbol = this.getScope((ParseTree)ctx).get(name);
            switch (symbol.getType()) {
                case SOURCE_IMAGE: {
                    GetSourceValue sourceValue = new GetSourceValue(name, ImagePos.DEFAULT);
                    this.readsOptimizer.add(sourceValue);
                    this.set((ParseTree)ctx, sourceValue);
                    break;
                }
                case LIST: {
                    this.set((ParseTree)ctx, new Variable(name, JiffleType.LIST));
                    break;
                }
                case LOOP_VAR: 
                case SCALAR: {
                    this.set((ParseTree)ctx, new Variable(name, JiffleType.D));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Compiler error: invalid type for variable '" + name + "'");
                }
            }
        }
    }

    @Override
    public void exitLiteral(JiffleParser.LiteralContext ctx) {
        Token tok = ctx.getStart();
        switch (tok.getType()) {
            case 62: {
                this.set((ParseTree)ctx, new IntLiteral(tok.getText()));
                break;
            }
            case 63: {
                this.set((ParseTree)ctx, new DoubleLiteral(tok.getText()));
                break;
            }
            case 3: {
                this.set((ParseTree)ctx, ConstantLiteral.trueValue());
                break;
            }
            case 4: {
                this.set((ParseTree)ctx, ConstantLiteral.falseValue());
                break;
            }
            case 5: {
                this.set((ParseTree)ctx, ConstantLiteral.nanValue());
                break;
            }
            default: {
                throw new JiffleParserException("Unrecognized literal type: " + tok.getText());
            }
        }
    }

    @Override
    public void exitListLiteral(JiffleParser.ListLiteralContext ctx) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (ctx.expressionList() != null && ctx.expressionList().expression() != null) {
            for (JiffleParser.ExpressionContext ec : ctx.expressionList().expression()) {
                Expression expression = this.getAsType((ParseTree)ec, Expression.class);
                expressions.add(expression);
            }
        }
        this.set((ParseTree)ctx, new ListLiteral(expressions));
    }

    protected abstract SymbolScope getScope(ParseTree var1);

    protected <N extends Node> N getAsType(ParseTree ctx, Class<N> clazz) {
        if (this.get(ctx) == null) {
            String lineColumn = "(unknown)";
            if (ctx instanceof ParserRuleContext) {
                ParserRuleContext prc = (ParserRuleContext)ctx;
                Token start = prc.getStart();
                lineColumn = "(" + start.getLine() + ":" + start.getCharPositionInLine() + ")";
            }
            throw new IllegalStateException("Internal compiler error: no property set for node of type " + ctx.getClass().getSimpleName() + " at " + lineColumn);
        }
        try {
            return (N)((Node)clazz.cast(this.get(ctx)));
        }
        catch (ClassCastException ex) {
            String msg = String.format("Internal compiler error: cannot cast %s to %s", ((Node)this.get(ctx)).getClass().getSimpleName(), clazz.getSimpleName());
            throw new IllegalStateException(msg);
        }
    }

    protected Expression[] asExpressions(List<JiffleParser.ExpressionContext> ctxs) {
        if (ctxs == null) {
            return new Expression[0];
        }
        Expression[] exprs = new Expression[ctxs.size()];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = this.getAsType((ParseTree)ctxs.get(i), Expression.class);
        }
        return exprs;
    }
}

