/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle;

import it.geosolutions.jaiext.jiffle.JiffleException;
import it.geosolutions.jaiext.jiffle.JiffleProperties;
import it.geosolutions.jaiext.jiffle.parser.ExpressionWorker;
import it.geosolutions.jaiext.jiffle.parser.ImagesBlockWorker;
import it.geosolutions.jaiext.jiffle.parser.InitBlockWorker;
import it.geosolutions.jaiext.jiffle.parser.JiffleLexer;
import it.geosolutions.jaiext.jiffle.parser.JiffleParser;
import it.geosolutions.jaiext.jiffle.parser.JiffleParserErrorListener;
import it.geosolutions.jaiext.jiffle.parser.Messages;
import it.geosolutions.jaiext.jiffle.parser.OptionsBlockWorker;
import it.geosolutions.jaiext.jiffle.parser.RuntimeModelWorker;
import it.geosolutions.jaiext.jiffle.parser.SourcePositionsWorker;
import it.geosolutions.jaiext.jiffle.parser.VarWorker;
import it.geosolutions.jaiext.jiffle.parser.node.GetSourceValue;
import it.geosolutions.jaiext.jiffle.parser.node.Script;
import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import it.geosolutions.jaiext.jiffle.runtime.JiffleDirectRuntime;
import it.geosolutions.jaiext.jiffle.runtime.JiffleIndirectRuntime;
import it.geosolutions.jaiext.jiffle.runtime.JiffleRuntime;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.codehaus.janino.SimpleCompiler;

public class Jiffle {
    public static final Logger LOGGER = Logger.getLogger(Jiffle.class.getName());
    private static Pattern BLOCK_COMMENT_STRIPPER = Pattern.compile("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)");
    private static int refCount = 0;
    private String name;
    private String theScript;
    private Script scriptModel;
    private Map<String, ImageRole> imageParams;
    private Map<String, Integer> destinationBands;

    public Jiffle() {
        this.init();
    }

    public Jiffle(String script, Map<String, ImageRole> params) throws JiffleException {
        this.init();
        this.setScript(script);
        this.setImageParams(params);
        this.compile();
    }

    public Jiffle(File scriptFile, Map<String, ImageRole> params) throws JiffleException {
        this.init();
        this.setScript(scriptFile);
        this.setImageParams(params);
        this.compile();
    }

    public final void setScript(String script) throws JiffleException {
        if (script == null || script.trim().length() == 0) {
            throw new JiffleException("script is empty !");
        }
        this.clearCompiledObjects();
        this.theScript = script + "\n";
    }

    public final void setScript(File scriptFile) throws JiffleException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(scriptFile));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                sb.append(line);
                sb.append('\n');
            }
            this.setScript(sb.toString());
        }
        catch (IOException ex) {
            throw new JiffleException("Could not read the script file", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getScript() {
        return this.theScript == null ? "" : this.theScript;
    }

    public final void setImageParams(Map<String, ImageRole> params) {
        this.imageParams.clear();
        this.imageParams.putAll(params);
    }

    public Map<String, ImageRole> getImageParams() {
        return Collections.unmodifiableMap(this.imageParams);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final void compile() throws JiffleException {
        if (this.theScript == null) {
            throw new JiffleException("No script has been set");
        }
        Result<ParseTree> parseResult = Jiffle.parseScript(this.theScript);
        if (parseResult.messages.isError()) {
            Jiffle.reportMessages(parseResult);
            return;
        }
        ParseTree tree = (ParseTree)parseResult.result;
        if (this.imageParams.isEmpty()) {
            Result<Map<String, ImageRole>> r = Jiffle.getScriptImageParams(tree);
            if (r.messages.isError()) {
                Jiffle.reportMessages(r);
                return;
            }
            if (((Map)r.result).isEmpty()) {
                throw new JiffleException("No image parameters provided and none found in script");
            }
            this.setImageParams((Map)r.result);
        }
        OptionsBlockWorker optionsWorker = new OptionsBlockWorker(tree);
        Jiffle.reportMessages(optionsWorker.messages);
        InitBlockWorker initWorker = new InitBlockWorker(tree);
        Jiffle.reportMessages(initWorker.messages);
        VarWorker vw = new VarWorker(tree, this.imageParams);
        ExpressionWorker expressionWorker = new ExpressionWorker(tree, vw);
        Jiffle.reportMessages(expressionWorker.messages);
        RuntimeModelWorker worker = new RuntimeModelWorker(tree, optionsWorker.options, expressionWorker.getProperties(), expressionWorker.getScopes());
        this.scriptModel = worker.getScriptNode();
        this.destinationBands = worker.getDestinationBands();
    }

    public boolean isCompiled() {
        return this.scriptModel != null;
    }

    public JiffleDirectRuntime getRuntimeInstance() throws JiffleException {
        return (JiffleDirectRuntime)this.getRuntimeInstance(RuntimeModel.DIRECT);
    }

    public JiffleRuntime getRuntimeInstance(RuntimeModel model) throws JiffleException {
        return this.createRuntimeInstance(model, this.getRuntimeBaseClass(model), false);
    }

    public <T extends JiffleRuntime> T getRuntimeInstance(Class<T> baseClass) throws JiffleException {
        RuntimeModel model = RuntimeModel.get(baseClass);
        if (model == null) {
            throw new JiffleException(baseClass.getName() + " does not implement a required Jiffle runtime interface");
        }
        return (T)this.createRuntimeInstance(model, baseClass, false);
    }

    private JiffleRuntime createRuntimeInstance(RuntimeModel model, Class<? extends JiffleRuntime> runtimeClass, boolean scriptInDocs) throws JiffleException {
        if (!this.isCompiled()) {
            throw new JiffleException("The script has not been compiled");
        }
        String runtimeSource = this.createRuntimeSource(model, runtimeClass.getName(), scriptInDocs);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Jiffle script compiled to:\n\n" + runtimeSource);
        }
        try {
            SimpleCompiler compiler = new SimpleCompiler();
            compiler.cook(runtimeSource);
            StringBuilder sb = new StringBuilder();
            sb.append(JiffleProperties.get("runtime.package")).append(".");
            switch (model) {
                case DIRECT: {
                    sb.append(JiffleProperties.get("direct.class"));
                    break;
                }
                case INDIRECT: {
                    sb.append(JiffleProperties.get("indirect.class"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Internal compiler error");
                }
            }
            Class<?> clazz = compiler.getClassLoader().loadClass(sb.toString());
            JiffleRuntime runtime = (JiffleRuntime)clazz.newInstance();
            runtime.setImageParams(this.imageParams);
            if (runtime instanceof JiffleIndirectRuntime) {
                ((JiffleIndirectRuntime)runtime).setDestinationBands(this.destinationBands);
            }
            return runtime;
        }
        catch (Exception ex) {
            throw new JiffleException("Runtime source error for source: " + runtimeSource, ex);
        }
    }

    public String getRuntimeSource(boolean scriptInDocs) throws JiffleException {
        return this.getRuntimeSource(RuntimeModel.DIRECT, scriptInDocs);
    }

    public String getRuntimeSource(RuntimeModel model, boolean scriptInDocs) throws JiffleException {
        return this.createRuntimeSource(model, this.getRuntimeBaseClass(model).getName(), scriptInDocs);
    }

    private Class<? extends JiffleRuntime> getRuntimeBaseClass(RuntimeModel model) {
        Class<? extends JiffleRuntime> baseClass = null;
        switch (model) {
            case DIRECT: {
                baseClass = JiffleProperties.DEFAULT_DIRECT_BASE_CLASS;
                break;
            }
            case INDIRECT: {
                baseClass = JiffleProperties.DEFAULT_INDIRECT_BASE_CLASS;
            }
        }
        return baseClass;
    }

    private String createRuntimeSource(RuntimeModel model, String baseClassName, boolean scriptInDocs) {
        if (scriptInDocs) {
            throw new RuntimeException("Do no know how to clean the block comments yet");
        }
        SourceWriter writer = new SourceWriter(model);
        writer.setScript(this.stripComments(this.theScript));
        writer.setBaseClassName(baseClassName);
        this.scriptModel.write(writer);
        return writer.getSource();
    }

    private String stripComments(String theScript) {
        return BLOCK_COMMENT_STRIPPER.matcher(theScript).replaceAll("");
    }

    private void init() {
        ++refCount;
        this.imageParams = new HashMap<String, ImageRole>();
    }

    private void clearCompiledObjects() {
    }

    private static Result<ParseTree> parseScript(String script) {
        CodePointCharStream input = CharStreams.fromString((String)script);
        JiffleLexer lexer = new JiffleLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JiffleParser parser = new JiffleParser((TokenStream)tokens);
        parser.removeErrorListeners();
        JiffleParserErrorListener errListener = new JiffleParserErrorListener();
        parser.addErrorListener((ANTLRErrorListener)errListener);
        JiffleParser.ScriptContext tree = parser.script();
        return new Result<JiffleParser.ScriptContext>(tree, errListener.messages);
    }

    private static Result<Map<String, ImageRole>> getScriptImageParams(ParseTree tree) {
        ImagesBlockWorker reader = new ImagesBlockWorker(tree);
        return new Result<Map<String, ImageRole>>(reader.imageVars, reader.messages);
    }

    private static void reportMessages(Result result) throws JiffleException {
        Jiffle.reportMessages(result.messages);
    }

    private static void reportMessages(Messages messages) throws JiffleException {
        if (messages.isError()) {
            String expectionMessage = messages.toString();
            throw new JiffleException(expectionMessage);
        }
    }

    public static Set<GetSourceValue> getReadPositions(String script, List<String> sourceImageNames) throws JiffleException {
        Result<ParseTree> parseResult = Jiffle.parseScript(script);
        if (parseResult.messages.isError()) {
            Jiffle.reportMessages(parseResult);
            return Collections.emptySet();
        }
        ParseTree tree = (ParseTree)parseResult.result;
        if (sourceImageNames == null) {
            Result<Map<String, ImageRole>> r = Jiffle.getScriptImageParams(tree);
            sourceImageNames = ((Map)r.result).entrySet().stream().filter(k -> k.getValue() == ImageRole.SOURCE).map(k -> (String)k.getKey()).collect(Collectors.toList());
        }
        if (sourceImageNames.isEmpty()) {
            return Collections.emptySet();
        }
        SourcePositionsWorker worker = new SourcePositionsWorker(tree, sourceImageNames);
        Set<GetSourceValue> positions = worker.getPositions();
        return positions;
    }

    private static class Result<T> {
        final T result;
        final Messages messages;

        public Result(T result, Messages messages) {
            this.result = result;
            this.messages = messages;
        }
    }

    public static enum ImageRole {
        SOURCE,
        DEST;

    }

    public static enum RuntimeModel {
        DIRECT(JiffleDirectRuntime.class),
        INDIRECT(JiffleIndirectRuntime.class);

        private Class<? extends JiffleRuntime> runtimeClass;

        private RuntimeModel(Class<? extends JiffleRuntime> clazz) {
            this.runtimeClass = clazz;
        }

        public Class<? extends JiffleRuntime> getRuntimeClass() {
            return this.runtimeClass;
        }

        public static RuntimeModel get(Class<? extends JiffleRuntime> clazz) {
            for (RuntimeModel t : RuntimeModel.values()) {
                if (!t.runtimeClass.isAssignableFrom(clazz)) continue;
                return t;
            }
            return null;
        }
    }
}

