/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classbreaks;

import it.geosolutions.jaiext.classbreaks.HistogramClassification;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

class ClassPercentagesManager {
    ClassPercentagesManager() {
    }

    double[] getPercentages(Map<Double, Integer> data, List<Double> breaks, double nValues, int numClasses) {
        double[] percentages = new double[numClasses];
        Set<Double> keys = data.keySet();
        for (int i = 0; i < numClasses; ++i) {
            double current = breaks.get(i);
            double next = breaks.get(i + 1);
            boolean last = numClasses == i + 1;
            double classMembers = last ? (double)this.getClassMembersCount(data, keys, v -> v >= current && v <= next) : (double)this.getClassMembersCount(data, keys, v -> v >= current && v < next);
            percentages[i] = classMembers / nValues * 100.0;
        }
        return percentages;
    }

    private int getClassMembersCount(Map<Double, Integer> data, Set<Double> keys, Predicate<Double> predicate) {
        int classMembersCount = 0;
        for (Double key : keys) {
            if (!predicate.test(key)) continue;
            classMembersCount += data.get(key).intValue();
        }
        return classMembersCount;
    }

    double[] getPercentages(List<Double> data, Double[] breaks, double totalSize, int numClasses) {
        double[] percentages = new double[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            double current = breaks[i];
            double next = breaks[i + 1];
            boolean last = numClasses == i + 1;
            double classMembers = last ? this.getClassMembersCount(v -> v >= current && v <= next, data) : this.getClassMembersCount(v -> v >= current && v < next, data);
            percentages[i] = classMembers / totalSize * 100.0;
        }
        return percentages;
    }

    private double getClassMembersCount(Predicate<Double> predicate, List<Double> values) {
        int classMembers = 0;
        for (int i = 0; i < values.size(); ++i) {
            if (!predicate.test(values.get(i))) continue;
            ++classMembers;
        }
        return classMembers;
    }

    double[] getPercentages(List<HistogramClassification.Bucket> buckets, List<Double> breaks, int numClasses) {
        int i;
        double[] percentages = new double[numClasses];
        double[] arClassMembers = new double[numClasses];
        int totalSize = 0;
        for (i = 0; i < buckets.size(); ++i) {
            HistogramClassification.Bucket b = buckets.get(i);
            totalSize += b.getCount();
            this.getClassMembersCount(numClasses, breaks, arClassMembers, b);
        }
        for (i = 0; i < numClasses; ++i) {
            percentages[i] = arClassMembers[i] / (double)totalSize * 100.0;
        }
        return percentages;
    }

    private void getClassMembersCount(int numClasses, List<Double> breaks, double[] arClassMembers, HistogramClassification.Bucket b) {
        int bucketCount = b.getCount();
        for (int i = 0; i < numClasses; ++i) {
            double current = breaks.get(i);
            double next = breaks.get(i + 1);
            boolean last = i + 1 == numClasses;
            Double overlapping = last ? this.getOverlappingPercentages(current, next, b.getMin(), b.getMax()) : this.getOverlappingPercentages(current, Math.nextDown(next), b.getMin(), b.getMax());
            if (overlapping == 1.0) {
                int n = i;
                arClassMembers[n] = arClassMembers[n] + (double)bucketCount;
                continue;
            }
            if (overlapping == 0.0) {
                int n = i;
                arClassMembers[n] = arClassMembers[n] + 0.0;
                continue;
            }
            double classMembers = overlapping * (double)bucketCount;
            int n = i;
            arClassMembers[n] = arClassMembers[n] + classMembers;
        }
    }

    private Double getOverlappingPercentages(double cMin, double cMax, double bMin, double bMax) {
        if (cMin > bMax || cMax < bMin) {
            return 0.0;
        }
        double regionMin = Math.max(cMin, bMin);
        double regionMax = Math.min(cMax, bMax);
        double dividend = regionMax - regionMin;
        double divider = bMax - bMin;
        if (divider == 0.0) {
            if (dividend == 0.0) {
                return 1.0;
            }
            return 0.0;
        }
        return dividend / divider;
    }
}

