/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classbreaks;

import it.geosolutions.jaiext.classbreaks.ClassificationMethod;
import it.geosolutions.jaiext.classbreaks.EqualIntervalBreaksOpImage;
import it.geosolutions.jaiext.classbreaks.NaturalBreaksHistogramOpImage;
import it.geosolutions.jaiext.classbreaks.NaturalBreaksOpImage;
import it.geosolutions.jaiext.classbreaks.QuantileBreaksHistogramOpImage;
import it.geosolutions.jaiext.classbreaks.QuantileBreaksOpImage;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ROI;

public class ClassBreaksRIF
extends CRIFImpl {
    public ClassBreaksRIF() {
        super("ClassBreaks");
    }

    public RenderedImage create(ParameterBlock pb, RenderingHints hints) {
        RenderedImage src = pb.getRenderedSource(0);
        int xStart = src.getMinX();
        int yStart = src.getMinY();
        Integer numBins = pb.getIntParameter(0);
        ClassificationMethod method = (ClassificationMethod)((Object)pb.getObjectParameter(1));
        Double[][] extrema = (Double[][])pb.getObjectParameter(2);
        ROI roi = (ROI)pb.getObjectParameter(3);
        Integer[] bands = (Integer[])pb.getObjectParameter(4);
        Integer xPeriod = pb.getIntParameter(5);
        Integer yPeriod = pb.getIntParameter(6);
        Double noData = (Double)pb.getObjectParameter(7);
        Boolean histogram = false;
        if (pb.getNumParameters() >= 9) {
            histogram = (Boolean)pb.getObjectParameter(8);
        }
        Integer histogramBins = 256;
        if (pb.getNumParameters() >= 10) {
            histogramBins = (Integer)pb.getObjectParameter(9);
        }
        Boolean percentages = false;
        if (pb.getNumParameters() >= 11) {
            percentages = (Boolean)pb.getObjectParameter(10);
        }
        switch (method) {
            case EQUAL_INTERVAL: {
                return new EqualIntervalBreaksOpImage(src, numBins, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, percentages);
            }
            case QUANTILE: {
                if (histogram.booleanValue()) {
                    return new QuantileBreaksHistogramOpImage(src, numBins, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, histogramBins, percentages);
                }
                return new QuantileBreaksOpImage(src, numBins, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, percentages);
            }
            case NATURAL_BREAKS: {
                if (histogram.booleanValue()) {
                    return new NaturalBreaksHistogramOpImage(src, numBins, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, histogramBins, percentages);
                }
                return new NaturalBreaksOpImage(src, numBins, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, percentages);
            }
        }
        throw new IllegalArgumentException(method.name());
    }
}

