/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class TIFFJPEGDecompressor
extends TIFFDecompressor {
    private static final String TURBO_JPEG_DECOMPRESSOR = "it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageReader";
    private static final boolean DEBUG = false;
    protected static final int SOI = 216;
    protected static final int EOI = 217;
    protected ImageReader JPEGReader = null;
    protected ImageReadParam JPEGParam;
    protected boolean hasJPEGTables = false;
    protected byte[] tables = null;
    private byte[] data = new byte[0];

    public void beginDecoding() {
        TIFFImageMetadata tmetadata;
        TIFFField f;
        if (this.JPEGReader == null) {
            Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName("jpeg");
            if (!iter.hasNext()) {
                throw new IllegalStateException("No JPEG readers found!");
            }
            this.JPEGReader = iter.next();
            String className = this.JPEGReader.getClass().getName();
            if (className.equalsIgnoreCase(TURBO_JPEG_DECOMPRESSOR)) {
                this.useTurbo = true;
            }
            this.JPEGParam = this.JPEGReader.getDefaultReadParam();
        }
        if ((f = (tmetadata = (TIFFImageMetadata)this.metadata).getTIFFField(347)) != null) {
            this.hasJPEGTables = true;
            this.tables = f.getAsBytes();
        } else {
            this.hasJPEGTables = false;
        }
    }

    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        this.stream.seek(this.offset);
        int dataLength = 0;
        if (this.hasJPEGTables) {
            dataLength = this.tables.length + this.byteCount;
            if (this.data.length < dataLength) {
                this.data = new byte[dataLength];
            }
            int dataOffset = this.tables.length;
            for (int i = this.tables.length - 2; i > 0; --i) {
                if ((this.tables[i] & 0xFF) != 255 || (this.tables[i + 1] & 0xFF) != 217) continue;
                dataOffset = i;
                break;
            }
            System.arraycopy(this.tables, 0, this.data, 0, dataOffset);
            byte byte1 = (byte)this.stream.read();
            byte byte2 = (byte)this.stream.read();
            if ((byte1 & 0xFF) != 255 || (byte2 & 0xFF) != 216) {
                this.data[dataOffset++] = byte1;
                this.data[dataOffset++] = byte2;
            }
            this.stream.readFully(this.data, dataOffset, this.byteCount - 2);
            if (this.useTurbo) {
                this.JPEGReader.setInput(this.data);
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
                MemoryCacheImageInputStream is = new MemoryCacheImageInputStream(bais);
                this.JPEGReader.setInput(is, false, true);
            }
        } else {
            ImageInputStream is = this.stream;
            this.JPEGReader.setInput(is, false, true);
        }
        if (this.useTurbo) {
            this.rawImage = this.JPEGReader.read(0);
        } else {
            this.JPEGParam.setDestination(this.rawImage);
            this.JPEGReader.read(0, this.JPEGParam);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.JPEGReader.dispose();
    }
}

