/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;

final class ScanlineCursor {
    final int scanlineStride;
    final int maxPosition;
    int position;

    public ScanlineCursor(Raster raster) {
        this.scanlineStride = this.getScanlineStride(raster);
        this.position = raster.getDataBuffer().getOffset();
        this.maxPosition = raster.getDataBuffer().getSize();
    }

    public int next() {
        int result = this.position;
        if (result >= this.maxPosition) {
            throw new IllegalStateException("We got past the end of the buffer, current position is " + this.position + " and max position value is " + this.maxPosition);
        }
        this.position += this.scanlineStride;
        return result;
    }

    int getScanlineStride(Raster raster) {
        if (raster.getSampleModel() instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)raster.getSampleModel();
            return csm.getScanlineStride();
        }
        return raster.getDataBuffer().getSize() / raster.getHeight();
    }
}

