/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;

public final class RasterIntABGRProvider
extends AbstractScanlineProvider {
    final int[] pixels;
    final boolean bgrOrder;
    final boolean hasAlpha;

    public RasterIntABGRProvider(Raster raster, boolean hasAlpha) {
        super(raster, 8, raster.getWidth() * (hasAlpha ? 4 : 3));
        int[] offsets;
        this.pixels = ((DataBufferInt)raster.getDataBuffer()).getData();
        this.hasAlpha = hasAlpha;
        this.bgrOrder = hasAlpha ? false : (offsets = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getBitOffsets())[0] != 0;
    }

    @Override
    public void next(byte[] row, int offset, int length) {
        int pxIdx = this.cursor.next();
        int i = offset;
        int max = offset + length;
        if (this.hasAlpha) {
            while (i < max) {
                int color = this.pixels[pxIdx++];
                row[i++] = (byte)(color >> 16 & 0xFF);
                row[i++] = (byte)(color >> 8 & 0xFF);
                row[i++] = (byte)(color & 0xFF);
                row[i++] = (byte)(color >> 24 & 0xFF);
            }
        } else if (this.bgrOrder) {
            while (i < max) {
                int color = this.pixels[pxIdx++];
                row[i++] = (byte)(color >> 16 & 0xFF);
                row[i++] = (byte)(color >> 8 & 0xFF);
                row[i++] = (byte)(color & 0xFF);
            }
        } else {
            while (i < max) {
                int color = this.pixels[pxIdx++];
                row[i++] = (byte)(color & 0xFF);
                row[i++] = (byte)(color >> 8 & 0xFF);
                row[i++] = (byte)(color >> 16 & 0xFF);
            }
        }
    }
}

