/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.JP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.ASOCBox;
import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BitsPerComponentBox;
import it.geosolutions.imageio.plugins.jp2k.box.CaptureResolutionBox;
import it.geosolutions.imageio.plugins.jp2k.box.ChannelDefinitionBox;
import it.geosolutions.imageio.plugins.jp2k.box.CodestreamHeaderBox;
import it.geosolutions.imageio.plugins.jp2k.box.ColorSpecificationBox;
import it.geosolutions.imageio.plugins.jp2k.box.ComponentMappingBox;
import it.geosolutions.imageio.plugins.jp2k.box.CompositingLayerHeaderBox;
import it.geosolutions.imageio.plugins.jp2k.box.ContiguousCodestreamBox;
import it.geosolutions.imageio.plugins.jp2k.box.DataEntryURLBox;
import it.geosolutions.imageio.plugins.jp2k.box.DefaultDisplayResolutionBox;
import it.geosolutions.imageio.plugins.jp2k.box.FileTypeBox;
import it.geosolutions.imageio.plugins.jp2k.box.IPRBox;
import it.geosolutions.imageio.plugins.jp2k.box.ImageHeaderBox;
import it.geosolutions.imageio.plugins.jp2k.box.JP2HeaderBox;
import it.geosolutions.imageio.plugins.jp2k.box.JP2KFileBox;
import it.geosolutions.imageio.plugins.jp2k.box.LabelBox;
import it.geosolutions.imageio.plugins.jp2k.box.PaletteBox;
import it.geosolutions.imageio.plugins.jp2k.box.ReaderRequirementsBox;
import it.geosolutions.imageio.plugins.jp2k.box.ResolutionBox;
import it.geosolutions.imageio.plugins.jp2k.box.SignatureBox;
import it.geosolutions.imageio.plugins.jp2k.box.UUIDBox;
import it.geosolutions.imageio.plugins.jp2k.box.UUIDInfoBox;
import it.geosolutions.imageio.plugins.jp2k.box.UUIDListBox;
import it.geosolutions.imageio.plugins.jp2k.box.XMLBox;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import kdu_jni.Jp2_input_box;
import kdu_jni.KduException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BoxUtilities {
    private static final Logger LOGGER = Logger.getLogger("BoxUtilities");
    public static final String JP2_ASOC_LBL_GML_DATA = "gml.data";
    public static final Map<Integer, Class<? extends BaseJP2KBox>> boxClasses = new HashMap<Integer, Class<? extends BaseJP2KBox>>();
    public static final Map<Integer, String> boxNames = new HashMap<Integer, String>();
    public static final Map<Integer, String> names = new HashMap<Integer, String>();
    public static final Set<String> SUPERBOX_NAMES = new HashSet<String>();

    public static void copyInt(byte[] data, int pos, int value) {
        data[pos++] = (byte)(value >> 24 & 0xFF);
        data[pos++] = (byte)(value >> 16 & 0xFF);
        data[pos++] = (byte)(value >> 8 & 0xFF);
        data[pos++] = (byte)value;
    }

    public static JP2KBox createBox(int type, Node node) throws IIOInvalidTreeException {
        Class<? extends BaseJP2KBox> boxClass = boxClasses.get(new Integer(type));
        try {
            Constructor<? extends BaseJP2KBox> cons = boxClass.getConstructor(Node.class);
            if (cons != null) {
                return cons.newInstance(node);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        throw new IllegalArgumentException("The provided type or Node are not valid");
    }

    public static JP2KBox createBox(int type, byte[] data) {
        Class<? extends BaseJP2KBox> boxClass = boxClasses.get(new Integer(type));
        try {
            if (data == null) {
                return boxClass.newInstance();
            }
            Constructor<? extends BaseJP2KBox> cons = boxClass.getConstructor(Array.newInstance(Byte.TYPE, 0).getClass());
            if (cons != null) {
                return cons.newInstance(new Object[]{data});
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        throw new IllegalArgumentException("The provided type or data are not valid");
    }

    public static Object getAttribute(Node node, String name) {
        NamedNodeMap map = node.getAttributes();
        return (node = map.getNamedItem(name)) != null ? node.getNodeValue() : null;
    }

    public static byte[] getByteArrayElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof byte[]) {
            return (byte[])obj;
        }
        return BoxUtilities.parseByteArray(node.getNodeValue());
    }

    public static byte getByteElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof Byte) {
            return (Byte)obj;
        }
        String value = node.getNodeValue();
        if (value != null) {
            return new Byte(value);
        }
        return 0;
    }

    public static int[] getIntArrayElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof int[]) {
            return (int[])obj;
        }
        return BoxUtilities.parseIntArray(node.getNodeValue());
    }

    public static int getIntElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof Integer) {
            return (Integer)obj;
        }
        String value = node.getNodeValue();
        if (value != null) {
            return new Integer(value);
        }
        return 0;
    }

    public static String getName(int type) {
        String name = names.get(new Integer(type));
        return name == null ? "unknown" : name;
    }

    public static String getBoxName(int type) {
        String name = boxNames.get(new Integer(type));
        return name == null ? "unknown" : name;
    }

    public static short getShortElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof Short) {
            return (Short)obj;
        }
        String value = node.getNodeValue();
        if (value != null) {
            return new Short(value);
        }
        return 0;
    }

    public static String getStringElementValue(Node node) {
        Object obj;
        if (node instanceof IIOMetadataNode && (obj = ((IIOMetadataNode)node).getUserObject()) instanceof String) {
            return (String)obj;
        }
        return node.getNodeValue();
    }

    public static String getTypeByName(String name) {
        for (Map.Entry<Integer, String> entry : names.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            return BoxUtilities.getTypeString(entry.getKey());
        }
        return null;
    }

    public static int getTypeInt(String s) {
        byte[] buf = s.getBytes();
        int t = buf[0];
        for (int i = 1; i < 4; ++i) {
            t = t << 8 | buf[i];
        }
        return t;
    }

    public static String getTypeString(int type) {
        byte[] buf = new byte[4];
        for (int i = 3; i >= 0; --i) {
            buf[i] = (byte)(type & 0xFF);
            type >>>= 8;
        }
        return new String(buf);
    }

    public static byte[] parseByteArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(value);
        int count = token.countTokens();
        byte[] buf = new byte[count];
        int i = 0;
        while (token.hasMoreElements()) {
            buf[i++] = new Byte(token.nextToken());
        }
        return buf;
    }

    public static int[] parseIntArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(value);
        int count = token.countTokens();
        int[] buf = new int[count];
        int i = 0;
        while (token.hasMoreElements()) {
            buf[i++] = new Integer(token.nextToken());
        }
        return buf;
    }

    public static Class<? extends BaseJP2KBox> getBoxClass(int type) {
        switch (type) {
            case 1919251232: 
            case 1919251299: 
            case 1919251300: {
                return ResolutionBox.class;
            }
        }
        return boxClasses.get(type);
    }

    public static int getValue(int c) {
        if (c < 58 && c >= 48) {
            return c - 48;
        }
        if (c < 71 && c >= 65) {
            return c - 55;
        }
        return -1;
    }

    public static byte[] getContent(Jp2_input_box box) throws KduException {
        int nBytes = (int)box.Get_box_bytes();
        byte[] buffer = new byte[nBytes];
        int readBytes = box.Read(buffer, nBytes);
        byte[] destBuffer = new byte[readBytes];
        System.arraycopy(buffer, 0, destBuffer, 0, readBytes);
        return destBuffer;
    }

    static {
        SUPERBOX_NAMES.add("jp2h");
        SUPERBOX_NAMES.add("res ");
        SUPERBOX_NAMES.add("uinf");
        SUPERBOX_NAMES.add("asoc");
        SUPERBOX_NAMES.add("jpch");
        SUPERBOX_NAMES.add("jplh");
        names.put(1, "JP2KFileBoxes");
        names.put(1783636000, "JP2KSignatureBox");
        names.put(1718909296, "JP2KFileTypeBox");
        names.put(1785737833, "JP2KIntellectualPropertyRightsBox");
        names.put(2020437024, "JP2KXMLBox");
        names.put(1785737832, "JP2KJP2HeaderBox");
        names.put(1785737827, "JPEG2000ContiguousCodestreamBox");
        names.put(1768449138, "JP2KImageHeaderBox");
        names.put(1651532643, "JP2KBitsPerComponentBox");
        names.put(1668246642, "JP2KColourSpecificationBox");
        names.put(1885564018, "JP2KPaletteBox");
        names.put(1668112752, "JP2KComponentMappingBox");
        names.put(1667523942, "JP2KChannelDefinitionBox");
        names.put(1919251232, "JP2KResolutionBox");
        names.put(1634955107, "JP2KAsocBox");
        names.put(1919251299, "JPEG2000CaptureResolutionBox");
        names.put(1919251300, "JPEG2000DefaultDisplayResolutionBox");
        names.put(1970628964, "JP2KUUIDBox");
        names.put(1969843814, "JP2KUUIDInfoBox");
        names.put(1970041716, "JP2KUUIDListBox");
        names.put(1970433056, "JP2KDataEntryURLBox");
        names.put(1920099697, "JP2KReaderRequirementsBox");
        names.put(1785750376, "JP2KCodestreamHeaderBox");
        names.put(1785752680, "JP2KCompositingLayerHeaderBox");
        names.put(1818389536, "JP2KLabelBox");
        boxClasses.put(1, JP2KFileBox.class);
        boxClasses.put(1783636000, SignatureBox.class);
        boxClasses.put(1718909296, FileTypeBox.class);
        boxClasses.put(1785737833, IPRBox.class);
        boxClasses.put(2020437024, XMLBox.class);
        boxClasses.put(1785737832, JP2HeaderBox.class);
        boxClasses.put(1785737827, ContiguousCodestreamBox.class);
        boxClasses.put(1768449138, ImageHeaderBox.class);
        boxClasses.put(1651532643, BitsPerComponentBox.class);
        boxClasses.put(1668246642, ColorSpecificationBox.class);
        boxClasses.put(1885564018, PaletteBox.class);
        boxClasses.put(1668112752, ComponentMappingBox.class);
        boxClasses.put(1667523942, ChannelDefinitionBox.class);
        boxClasses.put(1919251232, ResolutionBox.class);
        boxClasses.put(1634955107, ASOCBox.class);
        boxClasses.put(1919251299, CaptureResolutionBox.class);
        boxClasses.put(1919251300, DefaultDisplayResolutionBox.class);
        boxClasses.put(1969843814, UUIDInfoBox.class);
        boxClasses.put(1970628964, UUIDBox.class);
        boxClasses.put(1970041716, UUIDListBox.class);
        boxClasses.put(1970433056, DataEntryURLBox.class);
        boxClasses.put(1920099697, ReaderRequirementsBox.class);
        boxClasses.put(1785750376, CodestreamHeaderBox.class);
        boxClasses.put(1785752680, CompositingLayerHeaderBox.class);
        boxClasses.put(1818389536, LabelBox.class);
        boxNames.put(1, "jp2k");
        boxNames.put(1783636000, "jP  ");
        boxNames.put(1718909296, "ftyp");
        boxNames.put(1785737833, "jp2i");
        boxNames.put(2020437024, "xml ");
        boxNames.put(1785737832, "jp2h");
        boxNames.put(1785737827, "jp2c");
        boxNames.put(1634955107, "asoc");
        boxNames.put(1768449138, "ihdr");
        boxNames.put(1651532643, "bpcc");
        boxNames.put(1668246642, "colr");
        boxNames.put(1885564018, "pclr");
        boxNames.put(1668112752, "cmap");
        boxNames.put(1667523942, "cdef");
        boxNames.put(1919251232, "res ");
        boxNames.put(1919251299, "resc");
        boxNames.put(1919251300, "resd");
        boxNames.put(1970628964, "uuid");
        boxNames.put(1969843814, "uinf");
        boxNames.put(1970041716, "ulst");
        boxNames.put(1970433056, "url ");
        boxNames.put(1920099697, "rreq");
        boxNames.put(1785750376, "jpch");
        boxNames.put(1785752680, "jplh");
        boxNames.put(1818389536, "lbl ");
    }
}

