/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.manager;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.decoder.RESTStyle;
import it.geosolutions.geoserver.rest.decoder.RESTStyleList;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTAbstractManager;
import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServerRESTStyleManager
extends GeoServerRESTAbstractManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoServerRESTStyleManager.class);

    public GeoServerRESTStyleManager(URL restURL, String username, String password) throws IllegalArgumentException {
        super(restURL, username, password);
    }

    public boolean existsStyle(String name) throws RuntimeException {
        String url = this.buildXmlUrl(null, name);
        return HTTPUtils.exists(url, this.gsuser, this.gspass);
    }

    public RESTStyleList getStyles() {
        String url = "/rest/styles.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Styles list from " + url);
        }
        String response = HTTPUtils.get(this.gsBaseUrl + url, this.gsuser, this.gspass);
        return RESTStyleList.build(response);
    }

    public RESTStyle getStyle(String name) {
        String url = this.buildXmlUrl(null, name);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Style " + name + " from " + url);
        }
        String response = HTTPUtils.get(url, this.gsuser, this.gspass);
        return RESTStyle.build(response);
    }

    public String getSLD(String styleName) {
        String url = this.buildUrl(null, styleName, ".sld");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving SLD body from " + url);
        }
        return HTTPUtils.get(url, this.gsuser, this.gspass);
    }

    public boolean existsStyle(String workspace, String name) {
        String url = this.buildXmlUrl(workspace, name);
        return HTTPUtils.exists(url, this.gsuser, this.gspass);
    }

    public RESTStyleList getStyles(String workspace) {
        String url = "/rest/workspaces/" + workspace + "/styles.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Styles list from " + url);
        }
        String response = HTTPUtils.get(this.gsBaseUrl + url, this.gsuser, this.gspass);
        return RESTStyleList.build(response);
    }

    public RESTStyle getStyle(String workspace, String name) {
        String url = this.buildXmlUrl(workspace, name);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Style " + name + " from " + url);
        }
        String response = HTTPUtils.get(url, this.gsuser, this.gspass);
        return RESTStyle.build(response);
    }

    public String getSLD(String workspace, String name) {
        String url = this.buildUrl(workspace, name, ".sld");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving SLD body from " + url);
        }
        return HTTPUtils.get(url, this.gsuser, this.gspass);
    }

    public boolean publishStyle(String sldBody) {
        try {
            return this.publishStyle(sldBody, null);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean publishStyle(String sldBody, String name) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        String sUrl = this.buildPostUrl(null, name);
        String result = HTTPUtils.post(sUrl, sldBody, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean publishStyle(File sldFile) {
        return this.publishStyle(sldFile, null);
    }

    public boolean publishStyle(File sldFile, String name) {
        String sUrl = this.buildPostUrl(null, name);
        LOGGER.debug("POSTing new style " + name + " to " + sUrl);
        String result = HTTPUtils.post(sUrl, sldFile, GeoServerRESTPublisher.Format.SLD.getContentType(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyle(String sldBody, String name) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(null, name, null);
        String result = HTTPUtils.put(sUrl, sldBody, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyle(File sldFile, String name) throws IllegalArgumentException {
        if (sldFile == null) {
            throw new IllegalArgumentException("Unable to updateStyle using a null parameter file");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(null, name, null);
        String result = HTTPUtils.put(sUrl, sldFile, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean removeStyle(String styleName, boolean purge) throws IllegalArgumentException {
        if (styleName == null || styleName.isEmpty()) {
            throw new IllegalArgumentException("Check styleName parameter, it may never be null or empty");
        }
        if (styleName.contains(":")) {
            LOGGER.warn("Style name is going to be changed [" + styleName + "]");
        }
        styleName = styleName.replaceAll(":", "_");
        String sUrl = this.buildUrl(null, styleName, null);
        if (purge) {
            sUrl = sUrl + "?purge=true";
        }
        return HTTPUtils.delete(sUrl, this.gsuser, this.gspass);
    }

    public boolean removeStyle(String styleName) {
        try {
            return this.removeStyle(styleName, true);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean publishStyleInWorkspace(String workspace, String sldBody) {
        try {
            return this.publishStyleInWorkspace(workspace, sldBody);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean publishStyleInWorkspace(String workspace, String sldBody, String name) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        String sUrl = this.buildPostUrl(workspace, name);
        String result = HTTPUtils.post(sUrl, sldBody, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean publishStyleInWorkspace(String workspace, File sldFile) {
        return this.publishStyleInWorkspace(workspace, sldFile, null);
    }

    public boolean publishStyleInWorkspace(String workspace, File sldFile, String name) {
        String sUrl = this.buildPostUrl(workspace, name);
        LOGGER.debug("POSTing new style " + name + " to " + sUrl);
        String result = HTTPUtils.post(sUrl, sldFile, GeoServerRESTPublisher.Format.SLD.getContentType(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyleInWorkspace(String workspace, String sldBody, String name) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(workspace, name, null);
        String result = HTTPUtils.put(sUrl, sldBody, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyleInWorkspace(String workspace, File sldFile, String name) throws IllegalArgumentException {
        if (sldFile == null) {
            throw new IllegalArgumentException("Unable to updateStyle using a null parameter file");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(workspace, name, null);
        String result = HTTPUtils.put(sUrl, sldFile, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean removeStyleInWorkspace(String workspace, String styleName, boolean purge) throws IllegalArgumentException {
        if (styleName == null || styleName.isEmpty()) {
            throw new IllegalArgumentException("Check styleName parameter, it may never be null or empty");
        }
        if (styleName.contains(":")) {
            LOGGER.warn("Style name is going to be changed [" + styleName + "]");
        }
        styleName = styleName.replaceAll(":", "_");
        styleName = URLEncoder.encode(styleName);
        String sUrl = this.buildUrl(workspace, styleName, null);
        if (purge) {
            sUrl = sUrl + "?purge=true";
        }
        return HTTPUtils.delete(sUrl, this.gsuser, this.gspass);
    }

    public boolean removeStyleInWorkspace(String workspace, String styleName) {
        try {
            return this.removeStyleInWorkspace(workspace, styleName, true);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    protected String buildPostUrl(String workspace, String name) {
        StringBuilder sUrl = new StringBuilder(this.gsBaseUrl.toString()).append("/rest");
        if (workspace != null) {
            sUrl.append("/workspaces/").append(workspace);
        }
        sUrl.append("/styles");
        if (name != null && !name.isEmpty()) {
            sUrl.append("?name=").append(URLEncoder.encode(name));
        }
        return sUrl.toString();
    }

    protected String buildXmlUrl(String workspace, String name) {
        return this.buildUrl(workspace, name, ".xml");
    }

    protected String buildUrl(String workspace, String name, String ext) {
        StringBuilder sUrl = new StringBuilder(this.gsBaseUrl.toString()).append("/rest");
        if (workspace != null) {
            sUrl.append("/workspaces/").append(workspace);
        }
        sUrl.append("/styles/").append(URLEncoder.encode(name));
        if (ext != null) {
            sUrl.append(ext);
        }
        return sUrl.toString();
    }
}

