/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.datastore;

import it.geosolutions.geoserver.rest.decoder.RESTDataStore;
import it.geosolutions.geoserver.rest.encoder.datastore.GSAbstractDatastoreEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;

public class GSShapefileDatastoreEncoder
extends GSAbstractDatastoreEncoder {
    static final String TYPE = "Shapefile";
    static final boolean DEFAULT_ENABLED = true;
    static final String DEFAULT_CHARSET = "ISO-8859-1";
    static final boolean DEFAULT_CREATE_SPATIAL_INDEX = true;
    static final boolean DEFAULT_MEMORY_MAPPED_BUFFER = false;
    static final boolean DEFAULT_CACHE_AND_REUSE_MEMORY_MAPS = true;

    public GSShapefileDatastoreEncoder(String name, URL url) {
        super(name);
        this.setType(TYPE);
        GSShapefileDatastoreEncoder.ensureValidURL(url);
        this.setUrl(url);
        this.setEnabled(true);
        this.setCharset(Charset.forName(DEFAULT_CHARSET));
        this.setCreateSpatialIndex(true);
        this.setMemoryMappedBuffer(false);
        this.setCacheAndReuseMemoryMaps(true);
    }

    public GSShapefileDatastoreEncoder(RESTDataStore store) {
        super(store);
        try {
            GSShapefileDatastoreEncoder.ensureValidURL(new URL(store.getConnectionParameters().get("url")));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Shapefile store URL is malformed", e);
        }
    }

    public void setUrl(URL url) {
        GSShapefileDatastoreEncoder.ensureValidURL(url);
        this.connectionParameters.set("url", url.toString());
    }

    public URL getUrl() {
        try {
            return new URL(ElementUtils.contains(this.connectionParameters.getRoot(), "description").getTextTrim());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void setCharset(Charset charset) {
        this.connectionParameters.set("charset", charset.name());
    }

    public Charset getCharset() {
        return Charset.forName(ElementUtils.contains(this.connectionParameters.getRoot(), "charset").getTextTrim());
    }

    public void setCreateSpatialIndex(boolean createSpatialIndex) {
        this.connectionParameters.set("create spatial index", Boolean.toString(createSpatialIndex));
    }

    public boolean getCreateSpatialIndex() {
        return Boolean.parseBoolean(ElementUtils.contains(this.connectionParameters.getRoot(), "create spatial index").getTextTrim());
    }

    public void setMemoryMappedBuffer(boolean memoryMappedBuffer) {
        this.connectionParameters.set("memory mapped buffer", Boolean.toString(memoryMappedBuffer));
    }

    public boolean getMemoryMappedBuffer() {
        return Boolean.parseBoolean(ElementUtils.contains(this.connectionParameters.getRoot(), "memory mapped buffer").getTextTrim());
    }

    public void setCacheAndReuseMemoryMaps(boolean cacheAndReuseMemoryMaps) {
        this.connectionParameters.set("cache and reuse memory maps", Boolean.toString(cacheAndReuseMemoryMaps));
    }

    public boolean getCacheAndReuseMemoryMaps() {
        return Boolean.parseBoolean(ElementUtils.contains(this.connectionParameters.getRoot(), "cache and reuse memory maps").getTextTrim());
    }

    private static void ensureValidURL(URL url) {
        if (url == null || url.toString().isEmpty()) {
            throw new IllegalArgumentException("Shapefile store URL cannot be null or empty");
        }
    }

    @Override
    protected String getValidType() {
        return TYPE;
    }
}

