/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.authorityurl.AuthorityURLInfo;
import it.geosolutions.geoserver.rest.encoder.authorityurl.GSAuthorityURLInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.identifier.GSIdentifierInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.identifier.IdentifierInfo;
import it.geosolutions.geoserver.rest.encoder.utils.NestedElementEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Content;

public class GSLayerEncoder21
extends GSLayerEncoder {
    public static final String METADATA = "metadata";
    private final GSMetadataEncoder metadata = new GSMetadataEncoder();
    public Map<String, String> authorityURLList;
    public Map<String, List<String>> identifierList;

    public GSLayerEncoder21() {
        this.addContent((Content)this.metadata.getRoot());
        this.addAdvertised();
    }

    protected void addMetadata(String key, XmlElement dimensionInfo) {
        this.metadata.add(key, dimensionInfo.getRoot());
    }

    protected void addAdvertised() {
        this.metadata.add("advertised", "true");
    }

    @Override
    public void setAdvertised(boolean advertised) {
        if (advertised) {
            this.metadata.add("advertised", "true");
        } else {
            this.metadata.add("advertised", "false");
        }
    }

    @Override
    public void addAuthorityURL(GSAuthorityURLInfoEncoder authorityURLInfo) {
        if (this.authorityURLList == null) {
            this.authorityURLList = new HashMap<String, String>();
        }
        this.authorityURLList.put(authorityURLInfo.getHref(), authorityURLInfo.getName());
        String jsonStr = "";
        for (Map.Entry<String, String> entry : this.authorityURLList.entrySet()) {
            jsonStr = jsonStr + "{\"" + AuthorityURLInfo.name.name() + "\":\"" + entry.getValue() + "\"," + "\"" + AuthorityURLInfo.href.name() + "\":\"" + entry.getKey() + "\"" + "},";
        }
        this.metadata.set("authorityURLs", "[" + jsonStr + "]");
    }

    @Override
    public boolean delAuthorityURL(String authorityURL) {
        boolean delete = false;
        if (this.authorityURLList != null && !this.authorityURLList.isEmpty() && this.authorityURLList.containsKey(authorityURL)) {
            this.identifierList.remove(authorityURL);
            String jsonStr = "";
            for (Map.Entry<String, List<String>> entry : this.identifierList.entrySet()) {
                for (String value : entry.getValue()) {
                    jsonStr = jsonStr + "{\"" + AuthorityURLInfo.name.name() + "\":\"" + entry.getValue() + "\"," + "\"" + AuthorityURLInfo.href.name() + "\":\"" + value + "\"" + "},";
                }
            }
            this.metadata.set("identifiers", "[" + jsonStr + "]");
            delete = true;
        }
        return delete;
    }

    @Override
    public void addIdentifier(GSIdentifierInfoEncoder identifierInfo) {
        List<Object> ids;
        String authority;
        if (this.identifierList == null) {
            this.identifierList = new HashMap<String, List<String>>();
        }
        if (!this.identifierList.containsKey(authority = identifierInfo.getAuthority())) {
            ids = new ArrayList<String>();
            ids.add(identifierInfo.getIdentifier());
            this.identifierList.put(authority, ids);
        } else {
            ids = this.identifierList.get(authority);
            ids.add(identifierInfo.getIdentifier());
            this.identifierList.put(authority, ids);
        }
        String jsonStr = "";
        for (Map.Entry<String, List<String>> entry : this.identifierList.entrySet()) {
            for (String value : entry.getValue()) {
                jsonStr = jsonStr + "{\"" + IdentifierInfo.authority.name() + "\":\"" + entry.getKey() + "\"," + "\"" + IdentifierInfo.identifier.name() + "\":\"" + value + "\"" + "},";
            }
        }
        this.metadata.set("identifiers", "[" + jsonStr + "]");
    }

    @Override
    public boolean delIdentifier(String authority) {
        boolean delete = false;
        if (this.identifierList != null && !this.identifierList.isEmpty() && this.identifierList.containsKey(authority)) {
            this.identifierList.remove(authority);
            String jsonStr = "";
            for (Map.Entry<String, List<String>> entry : this.identifierList.entrySet()) {
                for (String value : entry.getValue()) {
                    jsonStr = jsonStr + "{\"" + IdentifierInfo.authority.name() + "\":\"" + entry.getKey() + "\"," + "\"" + IdentifierInfo.identifier.name() + "\":\"" + value + "\"" + "},";
                }
            }
            this.metadata.set("identifiers", "[" + jsonStr + "]");
            delete = true;
        }
        return delete;
    }

    private class GSMetadataEncoder
    extends NestedElementEncoder {
        public GSMetadataEncoder() {
            super(GSLayerEncoder21.METADATA);
        }
    }
}

