/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder.about;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class GSVersionDecoder
extends XmlElement {
    public static final String ABOUT = "about";
    private GSAboutResource geoserver;

    public GSVersionDecoder(String document) {
        Element root = JDOMBuilder.buildElement(document);
        if (root != null) {
            this.setRoot(root);
            this.geoserver = new GSAboutResource(ElementUtils.contains(this.getRoot(), "resource"));
        } else {
            this.create();
        }
    }

    public GSVersionDecoder() {
        this.create();
    }

    private void create() {
        this.setRoot(ABOUT);
        this.geoserver = new GSAboutResource();
        this.addContent((Content)this.geoserver.getRoot());
    }

    public GSAboutResource getGeoServer() {
        return this.geoserver;
    }

    public VERSION getVersion() {
        Element e = ElementUtils.contains(this.geoserver.version, "Version");
        return VERSION.getVersion(e.getTextTrim());
    }

    public int compareTo(VERSION v) {
        return this.getVersion().compareTo(v);
    }

    public static GSVersionDecoder build(String response) {
        return new GSVersionDecoder(response);
    }

    public static enum VERSION {
        UNRECOGNIZED(-1),
        v22(22),
        v23(23),
        v24(24),
        v25(25),
        ABOVE(9999);

        private final int version;

        private VERSION(int val) {
            this.version = val;
        }

        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return Integer.toString(this.version);
        }

        public static VERSION getVersion(String v) {
            if (v == null) {
                return UNRECOGNIZED;
            }
            if (v.matches("2\\.2.*")) {
                return v22;
            }
            if (v.matches("2\\.3.*")) {
                return v23;
            }
            if (v.matches("2\\.4.*")) {
                return v24;
            }
            if (v.matches("2\\.5.*")) {
                return v25;
            }
            if (v.matches("2\\..+")) {
                return ABOVE;
            }
            return UNRECOGNIZED;
        }

        public static String print() {
            return "[" + (Object)((Object)v22) + ", " + (Object)((Object)v23) + ", " + (Object)((Object)v24) + ", " + (Object)((Object)v25) + ", " + (Object)((Object)ABOVE) + ", " + (Object)((Object)UNRECOGNIZED) + "]";
        }
    }

    public class GSAboutResource
    extends XmlElement {
        public static final String RESOURCE = "resource";
        public static final String NAME = "name";
        public static final String VERSION = "Version";
        private Element version;

        public GSAboutResource() {
            this.create();
        }

        private void create() {
            this.setRoot(RESOURCE);
            this.version = new Element(VERSION);
            this.addContent((Content)this.version);
        }

        public void setName(String name) {
            Attribute _name = this.getRoot().getAttribute(NAME);
            if (name != null) {
                _name.setValue(name);
            } else {
                this.getRoot().setAttribute(NAME, name);
            }
        }

        public String getName() {
            Attribute name = this.getRoot().getAttribute(NAME);
            if (name != null) {
                return name.getValue();
            }
            return null;
        }

        public GSAboutResource(Element el) {
            if (el != null) {
                this.setRoot(el);
                this.version = ElementUtils.contains(el, VERSION);
            } else {
                this.create();
                this.setVersion(it.geosolutions.geoserver.rest.decoder.about.GSVersionDecoder$VERSION.UNRECOGNIZED.toString());
            }
        }

        public void setVersion(String v) {
            this.version.setText(v);
        }
    }
}

