/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.encoder.authorityurl.AuthorityURLInfo;
import it.geosolutions.geoserver.rest.encoder.authorityurl.GSAuthorityURLInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.identifier.GSIdentifierInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.identifier.IdentifierInfo;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class RESTLayer {
    protected final Element layerElem;

    public static RESTLayer build(String response) {
        if (response == null) {
            return null;
        }
        Element pb = JDOMBuilder.buildElement(response);
        if (pb != null) {
            return new RESTLayer(pb);
        }
        return null;
    }

    public RESTLayer(Element layerElem) {
        this.layerElem = layerElem;
    }

    public boolean getEnabled() {
        return Boolean.parseBoolean(this.layerElem.getChildText("enabled"));
    }

    public boolean getQueryable() {
        return Boolean.parseBoolean(this.layerElem.getChildText("queryable"));
    }

    public boolean getAdvertised() {
        return Boolean.parseBoolean(this.layerElem.getChildText("advertised"));
    }

    public String getName() {
        return this.layerElem.getChildText("name");
    }

    public String getTypeString() {
        return this.layerElem.getChildText("type");
    }

    public Type getType() {
        return Type.get(this.getTypeString());
    }

    public String getDefaultStyle() {
        Element defaultStyle = this.layerElem.getChild("defaultStyle");
        return defaultStyle == null ? null : defaultStyle.getChildText("name");
    }

    public String getDefaultStyleWorkspace() {
        Element defaultStyle = this.layerElem.getChild("defaultStyle");
        return defaultStyle == null ? null : defaultStyle.getChildText("workspace");
    }

    public String getTitle() {
        Element resource = this.layerElem.getChild("resource");
        return resource.getChildText("title");
    }

    public String getAbstract() {
        Element resource = this.layerElem.getChild("resource");
        return resource.getChildText("abstract");
    }

    public String getNameSpace() {
        Element resource = this.layerElem.getChild("resource");
        return resource.getChild("namespace").getChildText("name");
    }

    public String getResourceUrl() {
        Element resource = this.layerElem.getChild("resource");
        Element atom = resource.getChild("link", Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom"));
        return atom.getAttributeValue("href");
    }

    public List<GSAuthorityURLInfoEncoder> getEncodedAuthorityURLInfoList() {
        List authorityURLs;
        ArrayList<GSAuthorityURLInfoEncoder> authorityURLList = null;
        Element authorityURLsRoot = this.layerElem.getChild("authorityURLs");
        if (authorityURLsRoot != null && (authorityURLs = authorityURLsRoot.getChildren()) != null) {
            authorityURLList = new ArrayList<GSAuthorityURLInfoEncoder>(authorityURLs.size());
            for (Element authorityURL : authorityURLs) {
                GSAuthorityURLInfoEncoder authEnc = new GSAuthorityURLInfoEncoder();
                authEnc.setName(authorityURL.getChildText(AuthorityURLInfo.name.name()));
                authEnc.setHref(authorityURL.getChildText(AuthorityURLInfo.href.name()));
                authorityURLList.add(authEnc);
            }
        }
        return authorityURLList;
    }

    public List<GSIdentifierInfoEncoder> getEncodedIdentifierInfoList() {
        List identifiers;
        ArrayList<GSIdentifierInfoEncoder> idList = null;
        Element idRoot = this.layerElem.getChild("identifiers");
        if (idRoot != null && (identifiers = idRoot.getChildren()) != null) {
            idList = new ArrayList<GSIdentifierInfoEncoder>(identifiers.size());
            for (Element identifier : identifiers) {
                GSIdentifierInfoEncoder idEnc = new GSIdentifierInfoEncoder();
                idEnc.setAuthority(identifier.getChildText(IdentifierInfo.authority.name()));
                idEnc.setIdentifier(identifier.getChildText(IdentifierInfo.identifier.name()));
                idList.add(idEnc);
            }
        }
        return idList;
    }

    public static enum Type {
        VECTOR("VECTOR"),
        RASTER("RASTER"),
        UNKNOWN(null);

        private final String restName;

        private Type(String restName) {
            this.restName = restName;
        }

        public static Type get(String restName) {
            for (Type type : Type.values()) {
                if (type == UNKNOWN || !type.restName.equals(restName)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

