/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.RESTDimensionInfo;
import it.geosolutions.geoserver.rest.decoder.RESTMetadataList;
import it.geosolutions.geoserver.rest.decoder.RESTResource;
import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class RESTCoverage
extends RESTResource {
    public static RESTCoverage build(String response) {
        Element elem = JDOMBuilder.buildElement(response);
        return elem == null ? null : new RESTCoverage(elem);
    }

    public RESTCoverage(Element resource) {
        super(resource);
    }

    public RESTCoverage(RESTResource resource) {
        super(resource.rootElem);
    }

    public String getNativeFormat() {
        return this.rootElem.getChildText("nativeFormat");
    }

    public String getNativeCRS() {
        return this.rootElem.getChildText("nativeCRS");
    }

    public String getSRS() {
        return this.rootElem.getChildText("srs");
    }

    public RESTMetadataList getMetadataList() {
        return new RESTMetadataList(this.rootElem.getChild("metadata"));
    }

    public List<RESTDimensionInfo> getDimensionInfo() {
        ArrayList<RESTDimensionInfo> listDim = new ArrayList<RESTDimensionInfo>();
        for (RESTMetadataList.RESTMetadataElement el : this.getMetadataList()) {
            if (!el.getKey().equals("time") && !el.getKey().equals("elevation")) continue;
            listDim.add(new RESTDimensionInfo(el.getMetadataElem()));
        }
        return listDim;
    }

    public Map<String, String> getParametersList() {
        List params;
        HashMap<String, String> paramsList = new HashMap<String, String>();
        Element paramsRoot = this.rootElem.getChild("parameters");
        if (paramsRoot != null && (params = paramsRoot.getChildren()) != null) {
            for (Element param : params) {
                List values = param.getChildren();
                assert (values.size() == 2);
                paramsList.put(((Element)values.get(0)).getValue(), ((Element)values.get(1)).getValue());
            }
        }
        return paramsList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RESTCoverage [");
        if (this.getNativeFormat() != null) {
            builder.append("getNativeFormat()=");
            builder.append(this.getNativeFormat());
            builder.append(", ");
        }
        if (this.getNativeCRS() != null) {
            builder.append("getNativeCRS()=");
            builder.append(this.getNativeCRS());
            builder.append(", ");
        }
        if (this.getSRS() != null) {
            builder.append("getSRS()=");
            builder.append(this.getSRS());
            builder.append(", ");
        }
        if (this.getMetadataList() != null) {
            builder.append("getMetadataList()=");
            builder.append(this.getMetadataList());
            builder.append(", ");
        }
        if (this.getDimensionInfo() != null) {
            builder.append("getDimensionInfo()=");
            builder.append(this.getDimensionInfo());
            builder.append(", ");
        }
        if (this.getParametersList() != null) {
            builder.append("getParametersList()=");
            builder.append(this.getParametersList());
            builder.append(", ");
        }
        if (this.getName() != null) {
            builder.append("getName()=");
            builder.append(this.getName());
            builder.append(", ");
        }
        if (this.getTitle() != null) {
            builder.append("getTitle()=");
            builder.append(this.getTitle());
            builder.append(", ");
        }
        if (this.getNativeName() != null) {
            builder.append("getNativeName()=");
            builder.append(this.getNativeName());
            builder.append(", ");
        }
        if (this.getAbstract() != null) {
            builder.append("getAbstract()=");
            builder.append(this.getAbstract());
            builder.append(", ");
        }
        if (this.getNameSpace() != null) {
            builder.append("getNameSpace()=");
            builder.append(this.getNameSpace());
            builder.append(", ");
        }
        if (this.getStoreName() != null) {
            builder.append("getStoreName()=");
            builder.append(this.getStoreName());
            builder.append(", ");
        }
        if (this.getStoreType() != null) {
            builder.append("getStoreType()=");
            builder.append(this.getStoreType());
            builder.append(", ");
        }
        if (this.getStoreUrl() != null) {
            builder.append("getStoreUrl()=");
            builder.append(this.getStoreUrl());
            builder.append(", ");
        }
        if (this.getCRS() != null) {
            builder.append("getCRS()=");
            builder.append(this.getCRS());
            builder.append(", ");
        }
        builder.append("getMinX()=");
        builder.append(this.getMinX());
        builder.append(", getMaxX()=");
        builder.append(this.getMaxX());
        builder.append(", getMinY()=");
        builder.append(this.getMinY());
        builder.append(", getMaxY()=");
        builder.append(this.getMaxY());
        builder.append(", ");
        if (this.getAttributeList() != null) {
            builder.append("getAttributeList()=");
            builder.append(this.getAttributeList());
            builder.append(", ");
        }
        if (this.getEncodedAttributeList() != null) {
            builder.append("getEncodedAttributeList()=");
            builder.append(this.getEncodedAttributeList());
            builder.append(", ");
        }
        if (this.getEncodedMetadataLinkInfoList() != null) {
            builder.append("getEncodedMetadataLinkInfoList()=");
            builder.append(this.getEncodedMetadataLinkInfoList());
        }
        builder.append("]");
        return builder.toString();
    }
}

