/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPUtils.class);

    public static String get(String url) throws MalformedURLException {
        return HTTPUtils.get(url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, String username, String pw) {
        GetMethod httpMethod = null;
        HttpClient client = new HttpClient();
        HttpConnectionManager connectionManager = client.getHttpConnectionManager();
        try {
            HTTPUtils.setAuth(client, url, username, pw);
            httpMethod = new GetMethod(url);
            connectionManager.getParams().setConnectionTimeout(5000);
            int status = client.executeMethod((HttpMethod)httpMethod);
            if (status == 200) {
                InputStream is = httpMethod.getResponseBodyAsStream();
                String response = IOUtils.toString((InputStream)is);
                IOUtils.closeQuietly((InputStream)is);
                if (response.trim().length() == 0) {
                    LOGGER.warn("ResponseBody is empty");
                    String string = null;
                    return string;
                }
                String string = response;
                return string;
            }
            LOGGER.info("(" + status + ") " + HttpStatus.getStatusText((int)status) + " -- " + url);
        }
        catch (ConnectException e) {
            LOGGER.info("Couldn't connect to [" + url + "]");
        }
        catch (IOException e) {
            LOGGER.info("Error talking to [" + url + "]", (Throwable)e);
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
            connectionManager.closeIdleConnections(0L);
        }
        return null;
    }

    public static String put(String url, File file, String contentType, String username, String pw) {
        return HTTPUtils.put(url, (RequestEntity)new FileRequestEntity(file, contentType), username, pw);
    }

    public static String put(String url, String content, String contentType, String username, String pw) {
        try {
            return HTTPUtils.put(url, (RequestEntity)new StringRequestEntity(content, contentType, null), username, pw);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.error("Cannot PUT " + url, (Throwable)ex);
            return null;
        }
    }

    public static String putXml(String url, String content, String username, String pw) {
        return HTTPUtils.put(url, content, "text/xml", username, pw);
    }

    public static String put(String url, RequestEntity requestEntity, String username, String pw) {
        return HTTPUtils.send((EntityEnclosingMethod)new PutMethod(url), url, requestEntity, username, pw);
    }

    public static String post(String url, File file, String contentType, String username, String pw) {
        return HTTPUtils.post(url, (RequestEntity)new FileRequestEntity(file, contentType), username, pw);
    }

    public static String post(String url, String content, String contentType, String username, String pw) {
        try {
            return HTTPUtils.post(url, (RequestEntity)new StringRequestEntity(content, contentType, null), username, pw);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.error("Cannot POST " + url, (Throwable)ex);
            return null;
        }
    }

    public static String postXml(String url, String content, String username, String pw) {
        return HTTPUtils.post(url, content, "text/xml", username, pw);
    }

    public static String post(String url, RequestEntity requestEntity, String username, String pw) {
        return HTTPUtils.send((EntityEnclosingMethod)new PostMethod(url), url, requestEntity, username, pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String send(EntityEnclosingMethod httpMethod, String url, RequestEntity requestEntity, String username, String pw) {
        HttpClient client = new HttpClient();
        HttpConnectionManager connectionManager = client.getHttpConnectionManager();
        try {
            HTTPUtils.setAuth(client, url, username, pw);
            connectionManager.getParams().setConnectionTimeout(5000);
            if (requestEntity != null) {
                httpMethod.setRequestEntity(requestEntity);
            }
            int status = client.executeMethod((HttpMethod)httpMethod);
            switch (status) {
                case 200: 
                case 201: 
                case 202: {
                    String response = IOUtils.toString((InputStream)httpMethod.getResponseBodyAsStream());
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("HTTP " + httpMethod.getStatusText() + ": " + response);
                    }
                    String string = response;
                    return string;
                }
            }
            LOGGER.warn("Bad response: code[" + status + "]" + " msg[" + httpMethod.getStatusText() + "]" + " url[" + url + "]" + " method[" + httpMethod.getClass().getSimpleName() + "]: " + IOUtils.toString((InputStream)httpMethod.getResponseBodyAsStream()));
            String string = null;
            return string;
        }
        catch (ConnectException e) {
            LOGGER.info("Couldn't connect to [" + url + "]");
            String string = null;
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Error talking to " + url + " : " + e.getLocalizedMessage());
            String string = null;
            return string;
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
            connectionManager.closeIdleConnections(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(String url, String user, String pw) {
        DeleteMethod httpMethod = null;
        HttpClient client = new HttpClient();
        HttpConnectionManager connectionManager = client.getHttpConnectionManager();
        try {
            HTTPUtils.setAuth(client, url, user, pw);
            httpMethod = new DeleteMethod(url);
            connectionManager.getParams().setConnectionTimeout(5000);
            int status = client.executeMethod((HttpMethod)httpMethod);
            String response = "";
            if (status == 200) {
                InputStream is = httpMethod.getResponseBodyAsStream();
                response = IOUtils.toString((InputStream)is);
                IOUtils.closeQuietly((InputStream)is);
                if (response.trim().equals("")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("ResponseBody is empty (this may be not an error since we just performed a DELETE call)");
                    }
                    boolean bl = true;
                    return bl;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("(" + status + ") " + httpMethod.getStatusText() + " -- " + url);
                }
                boolean bl = true;
                return bl;
            }
            LOGGER.info("(" + status + ") " + httpMethod.getStatusText() + " -- " + url);
            LOGGER.info("Response: '" + response + "'");
        }
        catch (ConnectException e) {
            LOGGER.info("Couldn't connect to [" + url + "]");
        }
        catch (IOException e) {
            LOGGER.info("Error talking to [" + url + "]", (Throwable)e);
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
            connectionManager.closeIdleConnections(0L);
        }
        return false;
    }

    public static boolean httpPing(String url) {
        return HTTPUtils.httpPing(url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean httpPing(String url, String username, String pw) {
        GetMethod httpMethod = null;
        HttpClient client = new HttpClient();
        HttpConnectionManager connectionManager = client.getHttpConnectionManager();
        try {
            HTTPUtils.setAuth(client, url, username, pw);
            httpMethod = new GetMethod(url);
            connectionManager.getParams().setConnectionTimeout(2000);
            int status = client.executeMethod((HttpMethod)httpMethod);
            if (status != 200) {
                LOGGER.warn("PING failed at '" + url + "': (" + status + ") " + httpMethod.getStatusText());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (ConnectException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
            connectionManager.closeIdleConnections(0L);
        }
    }

    public static boolean exists(String url, String username, String pw) {
        GetMethod httpMethod = null;
        HttpClient client = new HttpClient();
        HttpConnectionManager connectionManager = client.getHttpConnectionManager();
        try {
            HTTPUtils.setAuth(client, url, username, pw);
            httpMethod = new GetMethod(url);
            connectionManager.getParams().setConnectionTimeout(2000);
            int status = client.executeMethod((HttpMethod)httpMethod);
            switch (status) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
            }
            try {
                throw new RuntimeException("Unhandled response status at '" + url + "': (" + status + ") " + httpMethod.getStatusText());
            }
            catch (ConnectException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
            connectionManager.closeIdleConnections(0L);
        }
    }

    private static void setAuth(HttpClient client, String url, String username, String pw) throws MalformedURLException {
        URL u = new URL(url);
        if (username != null && pw != null) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, pw);
            client.getState().setCredentials(new AuthScope(u.getHost(), u.getPort()), (Credentials)defaultcreds);
            client.getParams().setAuthenticationPreemptive(true);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Not setting credentials to access to " + url);
        }
    }

    public static String decurtSlash(String geoserverURL) {
        if (geoserverURL != null && geoserverURL.endsWith("/")) {
            geoserverURL = HTTPUtils.decurtSlash(geoserverURL.substring(0, geoserverURL.length() - 1));
        }
        return geoserverURL;
    }

    public static StringBuilder append(String ... str) {
        if (str == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (String s : str) {
            if (s == null) continue;
            buf.append(s);
        }
        return buf;
    }

    public static StringBuilder append(URL base, String ... str) {
        if (str == null) {
            return HTTPUtils.append(base.toString());
        }
        StringBuilder buf = new StringBuilder(base.toString());
        for (String s : str) {
            if (s == null) continue;
            buf.append(s);
        }
        return buf;
    }
}

