/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest;

import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.decoder.RESTCoverage;
import it.geosolutions.geoserver.rest.decoder.RESTCoverageList;
import it.geosolutions.geoserver.rest.decoder.RESTCoverageStore;
import it.geosolutions.geoserver.rest.decoder.RESTCoverageStoreList;
import it.geosolutions.geoserver.rest.decoder.RESTDataStore;
import it.geosolutions.geoserver.rest.decoder.RESTDataStoreList;
import it.geosolutions.geoserver.rest.decoder.RESTFeatureType;
import it.geosolutions.geoserver.rest.decoder.RESTFeatureTypeList;
import it.geosolutions.geoserver.rest.decoder.RESTLayer;
import it.geosolutions.geoserver.rest.decoder.RESTLayer21;
import it.geosolutions.geoserver.rest.decoder.RESTLayerGroup;
import it.geosolutions.geoserver.rest.decoder.RESTLayerGroupList;
import it.geosolutions.geoserver.rest.decoder.RESTLayerList;
import it.geosolutions.geoserver.rest.decoder.RESTNamespace;
import it.geosolutions.geoserver.rest.decoder.RESTNamespaceList;
import it.geosolutions.geoserver.rest.decoder.RESTResource;
import it.geosolutions.geoserver.rest.decoder.RESTStructuredCoverageGranulesList;
import it.geosolutions.geoserver.rest.decoder.RESTStructuredCoverageIndexSchema;
import it.geosolutions.geoserver.rest.decoder.RESTStyle;
import it.geosolutions.geoserver.rest.decoder.RESTStyleList;
import it.geosolutions.geoserver.rest.decoder.RESTWorkspaceList;
import it.geosolutions.geoserver.rest.decoder.about.GSVersionDecoder;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStructuredGridCoverageReaderManager;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStyleManager;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServerRESTReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoServerRESTReader.class);
    private final String baseurl;
    private String username;
    private String password;
    private GeoServerRESTStyleManager styleManager;

    public GeoServerRESTReader(URL gsUrl) {
        this.baseurl = this.init(gsUrl, null, null);
    }

    public GeoServerRESTReader(String gsUrl) throws MalformedURLException {
        this.baseurl = this.init(gsUrl, null, null);
    }

    public GeoServerRESTReader(String gsUrl, String username, String password) throws MalformedURLException {
        this.baseurl = this.init(gsUrl, username, password);
    }

    public GeoServerRESTReader(URL gsUrl, String username, String password) {
        this.baseurl = this.init(gsUrl, username, password);
    }

    private String init(String gsUrl, String username, String password) throws MalformedURLException {
        return this.init(new URL(gsUrl), username, password);
    }

    private String init(URL gsUrl, String username, String password) {
        String restUrl = gsUrl.toExternalForm();
        String cleanUrl = restUrl.endsWith("/") ? restUrl.substring(0, restUrl.length() - 1) : restUrl;
        this.username = username;
        this.password = password;
        this.styleManager = new GeoServerRESTStyleManager(gsUrl, username, password);
        return cleanUrl;
    }

    private String load(String url) {
        LOGGER.info("Loading from REST path " + url);
        String response = HTTPUtils.get(this.baseurl + url, this.username, this.password);
        return response;
    }

    private String loadFullURL(String url) {
        LOGGER.info("Loading from REST path " + url);
        String response = HTTPUtils.get(url, this.username, this.password);
        return response;
    }

    public boolean existGeoserver() {
        return HTTPUtils.httpPing(this.baseurl + "/rest/", this.username, this.password);
    }

    public GSVersionDecoder getGeoserverVersion() {
        String url = "/rest/about/version.xml";
        String xml = this.load("/rest/about/version.xml");
        if (xml == null) {
            GSVersionDecoder v = new GSVersionDecoder();
            v.getGeoServer().setVersion(GSVersionDecoder.VERSION.UNRECOGNIZED.toString());
            return v;
        }
        return GSVersionDecoder.build(this.load("/rest/about/version.xml"));
    }

    public boolean existsStyle(String styleName) throws RuntimeException {
        return this.styleManager.existsStyle(styleName);
    }

    public boolean existsStyle(String workspace, String styleName) throws RuntimeException {
        return this.styleManager.existsStyle(workspace, styleName);
    }

    public RESTStyle getStyle(String name) {
        return this.styleManager.getStyle(name);
    }

    public RESTStyle getStyle(String workspace, String name) {
        return this.styleManager.getStyle(workspace, name);
    }

    public RESTStyleList getStyles() {
        return this.styleManager.getStyles();
    }

    public RESTStyleList getStyles(String workspace) {
        return this.styleManager.getStyles(workspace);
    }

    public String getSLD(String styleName) {
        return this.styleManager.getSLD(styleName);
    }

    public String getSLD(String workspace, String styleName) {
        return this.styleManager.getSLD(workspace, styleName);
    }

    public RESTDataStoreList getDatastores(String workspace) {
        String url = "/rest/workspaces/" + workspace + "/datastores.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving DS list from " + url);
        }
        return RESTDataStoreList.build(this.load(url));
    }

    public RESTDataStore getDatastore(String workspace, String dsName) {
        String url = "/rest/workspaces/" + workspace + "/datastores/" + dsName + ".xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving DS from " + url);
        }
        String response = this.load(url);
        return RESTDataStore.build(response);
    }

    public RESTDataStore getDatastore(RESTFeatureType featureType) {
        String url = featureType.getStoreUrl();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving DS from fullurl " + url);
        }
        String response = this.loadFullURL(url);
        return RESTDataStore.build(response);
    }

    public RESTFeatureType getFeatureType(RESTLayer layer) {
        if (layer.getType() != RESTLayer.Type.VECTOR) {
            throw new RuntimeException("Bad layer type for layer " + layer.getName());
        }
        String response = this.loadFullURL(layer.getResourceUrl());
        return RESTFeatureType.build(response);
    }

    public RESTCoverageStoreList getCoverageStores(String workspace) {
        String url = "/rest/workspaces/" + workspace + "/coveragestores.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving CS list from " + url);
        }
        return RESTCoverageStoreList.build(this.load(url));
    }

    public RESTCoverageStore getCoverageStore(String workspace, String csName) {
        String url = "/rest/workspaces/" + workspace + "/coveragestores/" + csName + ".xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving CS from " + url);
        }
        return RESTCoverageStore.build(this.load(url));
    }

    public RESTCoverageStore getCoverageStore(RESTCoverage coverage) {
        String url = coverage.getStoreUrl();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving CS from fullurl " + url);
        }
        String response = this.loadFullURL(url);
        return RESTCoverageStore.build(response);
    }

    public RESTCoverageList getCoverages(String workspace, String csName) {
        String url = "/rest/workspaces/" + workspace + "/coveragestores/" + csName + "/coverages.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Covs from " + url);
        }
        return RESTCoverageList.build(this.load(url));
    }

    public RESTCoverage getCoverage(String workspace, String store, String name) {
        String url = "/rest/workspaces/" + workspace + "/coveragestores/" + store + "/coverages/" + name + ".xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Coverage from " + url);
        }
        return RESTCoverage.build(this.load(url));
    }

    public RESTCoverage getCoverage(RESTLayer layer) {
        if (layer.getType() != RESTLayer.Type.RASTER) {
            throw new RuntimeException("Bad layer type for layer " + layer.getName());
        }
        String response = this.loadFullURL(layer.getResourceUrl());
        return RESTCoverage.build(response);
    }

    public RESTResource getResource(RESTLayer layer) {
        String response = this.loadFullURL(layer.getResourceUrl());
        return RESTResource.build(response);
    }

    public RESTLayerGroupList getLayerGroups(String workspace) {
        String url = workspace == null ? "/rest/layergroups.xml" : "/rest/workspaces/" + workspace + "/layergroups.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving layergroups from " + url);
        }
        return RESTLayerGroupList.build(this.load(url));
    }

    public RESTLayerGroup getLayerGroup(String workspace, String name) {
        String url = workspace == null ? "/rest/layergroups/" + name + ".xml" : "/rest/workspaces/" + workspace + "/layergroups/" + name + ".xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving layergroup from " + url);
        }
        return RESTLayerGroup.build(this.load(url));
    }

    public RESTLayerGroupList getLayerGroups() {
        return this.getLayerGroups(null);
    }

    public RESTLayerGroup getLayerGroup(String name) {
        return this.getLayerGroup(null, name);
    }

    public RESTLayerList getLayers() {
        String url = "/rest/layers.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving layers from " + url);
        }
        return RESTLayerList.build(this.load(url));
    }

    public RESTFeatureTypeList getFeatureTypes(String workspace) {
        String url = "/rest/workspaces/" + workspace + "/featuretypes.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving featuretypes from " + url);
        }
        return RESTFeatureTypeList.build(this.load(url));
    }

    public RESTLayer getLayer(String name) {
        String url = "/rest/layers/" + name + ".xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving layer from " + url);
        }
        return RESTLayer.build(this.load(url));
    }

    public RESTLayer getLayer(String workspace, String name) {
        if (workspace == null || workspace.isEmpty()) {
            throw new IllegalArgumentException("Workspace may not be null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Layername may not be null");
        }
        String url = HTTPUtils.append("/rest/layers/", workspace, ":", name, ".xml").toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving layer from " + url);
        }
        RESTLayer layer = null;
        layer = this.getGeoserverVersion().getVersion().equals((Object)GSVersionDecoder.VERSION.UNRECOGNIZED) ? RESTLayer21.build(this.load(url)) : RESTLayer.build(this.load(url));
        return layer;
    }

    public RESTNamespace getNamespace(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException("Namespace prefix cannot be null or empty");
        }
        String url = "/rest/namespaces/" + prefix + ".xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Getting namespace from " + url);
        }
        return RESTNamespace.build(this.load(url));
    }

    public RESTNamespaceList getNamespaces() {
        String url = "/rest/namespaces.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving namespaces from " + url);
        }
        return RESTNamespaceList.build(this.load(url));
    }

    public List<String> getNamespaceNames() {
        RESTNamespaceList list = this.getNamespaces();
        ArrayList<String> names = new ArrayList<String>(list.size());
        for (RESTNamespaceList.RESTShortNamespace item : list) {
            names.add(item.getName());
        }
        return names;
    }

    public RESTWorkspaceList getWorkspaces() {
        String url = "/rest/workspaces.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving workspaces from " + url);
        }
        return RESTWorkspaceList.build(this.load(url));
    }

    public List<String> getWorkspaceNames() {
        RESTWorkspaceList list = this.getWorkspaces();
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(list.size());
        for (RESTWorkspaceList.RESTShortWorkspace item : list) {
            names.add(item.getName());
        }
        return names;
    }

    public RESTStructuredCoverageGranulesList getGranuleById(String workspace, String coverageStore, String coverage, String id) throws MalformedURLException, UnsupportedEncodingException {
        block4: {
            try {
                GeoServerRESTStructuredGridCoverageReaderManager manager = new GeoServerRESTStructuredGridCoverageReaderManager(new URL(this.baseurl), this.username, this.password);
                return manager.getGranuleById(workspace, coverageStore, coverage, id);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public RESTStructuredCoverageIndexSchema getGranuleIndexSchema(String workspace, String coverageStore, String coverage) throws MalformedURLException {
        block4: {
            try {
                GeoServerRESTStructuredGridCoverageReaderManager manager = new GeoServerRESTStructuredGridCoverageReaderManager(new URL(this.baseurl), this.username, this.password);
                return manager.getGranuleIndexSchema(workspace, coverageStore, coverage);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public RESTStructuredCoverageGranulesList getGranules(String workspace, String coverageStore, String coverage, String filter, Integer offset, Integer limit) throws MalformedURLException, UnsupportedEncodingException {
        block4: {
            try {
                GeoServerRESTStructuredGridCoverageReaderManager manager = new GeoServerRESTStructuredGridCoverageReaderManager(new URL(this.baseurl), this.username, this.password);
                return manager.getGranules(workspace, coverageStore, coverage, filter, offset, limit);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

