/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter.okhttp3;

import okhttp3.HttpUrl;
import zipkin.reporter.Encoding;
import zipkin.reporter.okhttp3.OkHttpSender;
import zipkin.reporter.okhttp3.RequestBodyMessageEncoder;

final class AutoValue_OkHttpSender
extends OkHttpSender {
    private final Encoding encoding;
    private final int messageMaxBytes;
    private final HttpUrl endpoint;
    private final int maxRequests;
    private final boolean compressionEnabled;
    private final RequestBodyMessageEncoder encoder;

    private AutoValue_OkHttpSender(Encoding encoding, int messageMaxBytes, HttpUrl endpoint, int maxRequests, boolean compressionEnabled, RequestBodyMessageEncoder encoder) {
        this.encoding = encoding;
        this.messageMaxBytes = messageMaxBytes;
        this.endpoint = endpoint;
        this.maxRequests = maxRequests;
        this.compressionEnabled = compressionEnabled;
        this.encoder = encoder;
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    @Override
    HttpUrl endpoint() {
        return this.endpoint;
    }

    @Override
    int maxRequests() {
        return this.maxRequests;
    }

    @Override
    boolean compressionEnabled() {
        return this.compressionEnabled;
    }

    @Override
    RequestBodyMessageEncoder encoder() {
        return this.encoder;
    }

    public String toString() {
        return "OkHttpSender{encoding=" + this.encoding + ", " + "messageMaxBytes=" + this.messageMaxBytes + ", " + "endpoint=" + this.endpoint + ", " + "maxRequests=" + this.maxRequests + ", " + "compressionEnabled=" + this.compressionEnabled + ", " + "encoder=" + (Object)((Object)this.encoder) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OkHttpSender) {
            OkHttpSender that = (OkHttpSender)((Object)o);
            return this.encoding.equals((Object)that.encoding()) && this.messageMaxBytes == that.messageMaxBytes() && this.endpoint.equals((Object)that.endpoint()) && this.maxRequests == that.maxRequests() && this.compressionEnabled == that.compressionEnabled() && this.encoder.equals((Object)that.encoder());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.encoding.hashCode();
        h *= 1000003;
        h ^= this.messageMaxBytes;
        h *= 1000003;
        h ^= this.endpoint.hashCode();
        h *= 1000003;
        h ^= this.maxRequests;
        h *= 1000003;
        h ^= this.compressionEnabled ? 1231 : 1237;
        h *= 1000003;
        return h ^= this.encoder.hashCode();
    }

    static final class Builder
    extends OkHttpSender.Builder {
        private Encoding encoding;
        private Integer messageMaxBytes;
        private HttpUrl endpoint;
        private Integer maxRequests;
        private Boolean compressionEnabled;
        private RequestBodyMessageEncoder encoder;

        Builder() {
        }

        Builder(OkHttpSender source) {
            this.encoding = source.encoding();
            this.messageMaxBytes = source.messageMaxBytes();
            this.endpoint = source.endpoint();
            this.maxRequests = source.maxRequests();
            this.compressionEnabled = source.compressionEnabled();
            this.encoder = source.encoder();
        }

        @Override
        public OkHttpSender.Builder encoding(Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public Encoding encoding() {
            if (this.encoding == null) {
                throw new IllegalStateException("Property \"encoding\" has not been set");
            }
            return this.encoding;
        }

        @Override
        public OkHttpSender.Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        @Override
        public OkHttpSender.Builder endpoint(HttpUrl endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public OkHttpSender.Builder maxRequests(int maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        @Override
        public int maxRequests() {
            if (this.maxRequests == null) {
                throw new IllegalStateException("Property \"maxRequests\" has not been set");
            }
            return this.maxRequests;
        }

        @Override
        public OkHttpSender.Builder compressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        @Override
        public OkHttpSender.Builder encoder(RequestBodyMessageEncoder encoder) {
            this.encoder = encoder;
            return this;
        }

        @Override
        public OkHttpSender autoBuild() {
            String missing = "";
            if (this.encoding == null) {
                missing = missing + " encoding";
            }
            if (this.messageMaxBytes == null) {
                missing = missing + " messageMaxBytes";
            }
            if (this.endpoint == null) {
                missing = missing + " endpoint";
            }
            if (this.maxRequests == null) {
                missing = missing + " maxRequests";
            }
            if (this.compressionEnabled == null) {
                missing = missing + " compressionEnabled";
            }
            if (this.encoder == null) {
                missing = missing + " encoder";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_OkHttpSender(this.encoding, this.messageMaxBytes, this.endpoint, this.maxRequests, this.compressionEnabled, this.encoder);
        }
    }
}

