/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.okhttp;

import com.github.kristofa.brave.KeyValueAnnotation;
import java.util.Collections;
import java.util.List;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpParser {
    public String applicationSpanName(Request request) {
        return !(request.tag() instanceof Request) ? request.tag().toString() : request.method();
    }

    public String networkSpanName(Request request) {
        return request.method();
    }

    public List<KeyValueAnnotation> networkRequestTags(Request request) {
        return Collections.singletonList(KeyValueAnnotation.create((String)"http.url", (String)request.url().toString()));
    }

    public List<KeyValueAnnotation> networkResponseTags(Response response) {
        int code = response.code();
        if (response.isSuccessful()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(KeyValueAnnotation.create((String)"http.status_code", (String)String.valueOf(code)));
    }
}

