/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.internal.Nullable;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;

public abstract class AnnotationSubmitter {
    public static AnnotationSubmitter create(SpanAndEndpoint spanAndEndpoint) {
        return new AnnotationSubmitterImpl(spanAndEndpoint);
    }

    abstract SpanAndEndpoint spanAndEndpoint();

    public void submitAnnotation(String value) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            Annotation annotation = Annotation.create(this.currentTimeMicroseconds(), value, this.spanAndEndpoint().endpoint());
            this.addAnnotation(span, annotation);
        }
    }

    public void submitAnnotation(String value, long timestamp) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            Annotation annotation = Annotation.create(timestamp, value, this.spanAndEndpoint().endpoint());
            this.addAnnotation(span, annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitStartAnnotation(String annotationName) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            Annotation annotation = Annotation.create(this.currentTimeMicroseconds(), annotationName, this.spanAndEndpoint().endpoint());
            Span span2 = span;
            synchronized (span2) {
                span.setTimestamp(annotation.timestamp);
                span.addToAnnotations(annotation);
            }
        }
    }

    boolean submitEndAnnotation(String annotationName, SpanCollector spanCollector) {
        Span span = this.spanAndEndpoint().span();
        if (span == null) {
            return false;
        }
        Annotation annotation = Annotation.create(this.currentTimeMicroseconds(), annotationName, this.spanAndEndpoint().endpoint());
        span.addToAnnotations(annotation);
        if (span.getTimestamp() != null) {
            span.setDuration(annotation.timestamp - span.getTimestamp());
        }
        spanCollector.collect(span);
        return true;
    }

    void submitAddress(String key, int ipv4, int port, @Nullable String serviceName) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            serviceName = serviceName != null ? serviceName : "unknown";
            Endpoint endpoint = Endpoint.create(serviceName, ipv4, port);
            BinaryAnnotation ba = BinaryAnnotation.address(key, endpoint);
            this.addBinaryAnnotation(span, ba);
        }
    }

    public void submitBinaryAnnotation(String key, String value) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            BinaryAnnotation ba = BinaryAnnotation.create(key, value, this.spanAndEndpoint().endpoint());
            this.addBinaryAnnotation(span, ba);
        }
    }

    public void submitBinaryAnnotation(String key, int value) {
        this.submitBinaryAnnotation(key, String.valueOf(value));
    }

    long currentTimeMicroseconds() {
        return System.currentTimeMillis() * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAnnotation(Span span, Annotation annotation) {
        Span span2 = span;
        synchronized (span2) {
            span.addToAnnotations(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBinaryAnnotation(Span span, BinaryAnnotation ba) {
        Span span2 = span;
        synchronized (span2) {
            span.addToBinary_annotations(ba);
        }
    }

    AnnotationSubmitter() {
    }

    private static final class AnnotationSubmitterImpl
    extends AnnotationSubmitter {
        private final SpanAndEndpoint spanAndEndpoint;

        private AnnotationSubmitterImpl(SpanAndEndpoint spanAndEndpoint) {
            this.spanAndEndpoint = Util.checkNotNull(spanAndEndpoint, "Null spanAndEndpoint", new Object[0]);
        }

        @Override
        SpanAndEndpoint spanAndEndpoint() {
            return this.spanAndEndpoint;
        }
    }
}

