/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.BoundedArrayQueue;
import io.zeebe.util.sched.ActorJob;
import io.zeebe.util.sched.ActorTask;
import io.zeebe.util.sched.ActorThreadGroup;
import io.zeebe.util.sched.ActorTimerQueue;
import io.zeebe.util.sched.TaskScheduler;
import io.zeebe.util.sched.TimerSubscription;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.clock.DefaultActorClock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.ManyToManyConcurrentArrayQueue;
import org.slf4j.MDC;
import sun.misc.Unsafe;

public class ActorThread
extends Thread
implements Consumer<Runnable> {
    static final Unsafe UNSAFE = UnsafeAccess.UNSAFE;
    private volatile ActorThreadState state;
    private static final long STATE_OFFSET;
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    public final ManyToManyConcurrentArrayQueue<Runnable> submittedCallbacks = new ManyToManyConcurrentArrayQueue(24576);
    private final ActorClock clock;
    private final int threadId;
    private final TaskScheduler taskScheduler;
    protected final ActorTimerQueue timerJobQueue;
    private final BoundedArrayQueue<ActorJob> jobs = new BoundedArrayQueue(2048);
    private final ActorThreadGroup actorThreadGroup;
    protected ActorTaskRunnerIdleStrategy idleStrategy = new ActorTaskRunnerIdleStrategy();
    ActorTask currentTask;

    public ActorThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorTimerQueue timerQueue) {
        this.setName(name);
        this.state = ActorThreadState.NEW;
        this.threadId = id;
        this.clock = clock != null ? clock : new DefaultActorClock();
        this.timerJobQueue = timerQueue != null ? timerQueue : new ActorTimerQueue(this.clock);
        this.actorThreadGroup = threadGroup;
        this.taskScheduler = taskScheduler;
    }

    @Override
    public void run() {
        this.idleStrategy.init();
        while (this.state == ActorThreadState.RUNNING) {
            try {
                this.doWork();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.state = ActorThreadState.TERMINATED;
        this.terminationFuture.complete(null);
    }

    private void doWork() {
        this.submittedCallbacks.drain((Consumer)this);
        if (this.clock.update()) {
            this.timerJobQueue.processExpiredTimers(this.clock);
        }
        this.currentTask = this.taskScheduler.getNextTask(this.clock);
        if (this.currentTask != null) {
            try {
                this.executeCurrentTask();
            }
            finally {
                this.taskScheduler.onTaskReleased(this.currentTask);
            }
        } else {
            this.idleStrategy.onIdle();
        }
    }

    private void executeCurrentTask() {
        MDC.put((String)"actor-name", (String)this.currentTask.getName());
        this.idleStrategy.onTaskExecuted();
        boolean resubmit = false;
        try {
            resubmit = this.currentTask.execute(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MDC.remove((String)"actor-name");
            this.clock.update();
        }
        if (resubmit) {
            this.currentTask.resubmit();
        }
    }

    public void hintWorkAvailable() {
        this.idleStrategy.hintWorkAvailable();
    }

    public void scheduleTimer(TimerSubscription timer) {
        this.timerJobQueue.schedule(timer, this.clock);
    }

    public void removeTimer(TimerSubscription timer) {
        this.timerJobQueue.remove(timer);
    }

    public static ActorThread current() {
        try {
            return (ActorThread)Thread.currentThread();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public ActorJob newJob() {
        ActorJob job = this.jobs.poll();
        if (job == null) {
            job = new ActorJob();
        }
        return job;
    }

    void recycleJob(ActorJob j) {
        j.reset();
        this.jobs.offer(j);
    }

    public int getRunnerId() {
        return this.threadId;
    }

    @Override
    public void start() {
        if (!UNSAFE.compareAndSwapObject(this, STATE_OFFSET, (Object)ActorThreadState.NEW, (Object)ActorThreadState.RUNNING)) {
            throw new IllegalStateException("Cannot start runner, not in state 'NEW'.");
        }
        super.start();
    }

    public CompletableFuture<Void> close() {
        if (UNSAFE.compareAndSwapObject(this, STATE_OFFSET, (Object)ActorThreadState.RUNNING, (Object)ActorThreadState.TERMINATING)) {
            return this.terminationFuture;
        }
        throw new IllegalStateException("Cannot stop runner, not in state 'RUNNING'.");
    }

    public ActorJob getCurrentJob() {
        ActorTask task = this.getCurrentTask();
        if (task != null) {
            return task.currentJob;
        }
        return null;
    }

    public ActorTask getCurrentTask() {
        return this.currentTask;
    }

    public ActorClock getClock() {
        return this.clock;
    }

    public ActorThreadGroup getActorThreadGroup() {
        return this.actorThreadGroup;
    }

    @Override
    public void accept(Runnable t) {
        t.run();
    }

    static {
        try {
            STATE_OFFSET = UNSAFE.objectFieldOffset(ActorThread.class.getDeclaredField("state"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ActorThreadState {
        NEW,
        RUNNING,
        TERMINATING,
        TERMINATED;

    }

    protected class ActorTaskRunnerIdleStrategy {
        final BackoffIdleStrategy backoff = new BackoffIdleStrategy(100L, 100L, 1L, TimeUnit.MILLISECONDS.toNanos(1L));
        boolean isIdle;
        long idleTimeStart;
        long busyTimeStart;

        protected ActorTaskRunnerIdleStrategy() {
        }

        void init() {
            this.isIdle = true;
            this.idleTimeStart = System.nanoTime();
        }

        public void hintWorkAvailable() {
            LockSupport.unpark(ActorThread.this);
        }

        protected void onIdle() {
            if (!this.isIdle) {
                ActorThread.this.clock.update();
                this.idleTimeStart = ActorThread.this.clock.getNanoTime();
                this.isIdle = true;
            }
            this.backoff.idle();
        }

        protected void onTaskExecuted() {
            this.backoff.reset();
            if (this.isIdle) {
                this.busyTimeStart = ActorThread.this.clock.getNanoTime();
                this.isIdle = false;
            }
        }
    }
}

