/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.Loggers;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorExecutor;
import io.zeebe.util.sched.ActorJob;
import io.zeebe.util.sched.ActorPriority;
import io.zeebe.util.sched.ActorSubscription;
import io.zeebe.util.sched.ActorThread;
import io.zeebe.util.sched.ActorThreadGroup;
import io.zeebe.util.sched.ClosedQueue;
import io.zeebe.util.sched.SchedulingHints;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Queue;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;

public class ActorTask {
    private static final long STATE_COUNT_OFFSET;
    private static final long SCHEDULING_STATE_OFFSET;
    public final CompletableActorFuture<Void> closeFuture = new CompletableActorFuture();
    private final CompletableActorFuture<Void> jobClosingTaskFuture = new CompletableActorFuture();
    private final CompletableActorFuture<Void> startingFuture = new CompletableActorFuture();
    private final CompletableActorFuture<Void> jobStartingTaskFuture = new CompletableActorFuture();
    final Actor actor;
    private ActorExecutor actorExecutor;
    private ActorThreadGroup actorThreadGroup;
    private volatile Queue<ActorJob> submittedJobs = new ClosedQueue();
    private Deque<ActorJob> fastLaneJobs = new ClosedQueue();
    private ActorLifecyclePhase lifecyclePhase = ActorLifecyclePhase.CLOSED;
    volatile TaskSchedulingState schedulingState = null;
    volatile long stateCount = 0L;
    ActorJob currentJob;
    private ActorSubscription[] subscriptions = new ActorSubscription[0];
    boolean shouldYield;
    private int priority = ActorPriority.REGULAR.getPriorityClass();

    public ActorTask(Actor actor) {
        this.actor = actor;
    }

    public ActorFuture<Void> onTaskScheduled(ActorExecutor actorExecutor, ActorThreadGroup actorThreadGroup) {
        this.actorExecutor = actorExecutor;
        this.actorThreadGroup = actorThreadGroup;
        this.closeFuture.close();
        this.closeFuture.setAwaitingResult();
        this.jobClosingTaskFuture.close();
        this.jobClosingTaskFuture.setAwaitingResult();
        this.startingFuture.close();
        this.startingFuture.setAwaitingResult();
        this.jobStartingTaskFuture.close();
        this.jobStartingTaskFuture.setAwaitingResult();
        this.submittedJobs = new ManyToOneConcurrentLinkedQueue();
        this.fastLaneJobs = new ArrayDeque<ActorJob>();
        this.lifecyclePhase = ActorLifecyclePhase.STARTING;
        ActorJob j = new ActorJob();
        j.setRunnable(this.actor::onActorStarting);
        j.setResultFuture(this.jobStartingTaskFuture);
        j.setAutoCompleting(true);
        j.onJobAddedToTask(this);
        this.currentJob = j;
        return this.startingFuture;
    }

    public void submit(ActorJob job) {
        Queue<ActorJob> submittedJobs = this.submittedJobs;
        if (submittedJobs.offer(job)) {
            if (submittedJobs != this.submittedJobs) {
                this.failJob(job);
            } else {
                this.tryWakeup();
            }
        } else {
            job.failFuture("Was not able to submit job to the actors queue.");
        }
    }

    public boolean execute(ActorThread runner) {
        this.schedulingState = TaskSchedulingState.ACTIVE;
        boolean resubmit = false;
        while (!resubmit && (this.currentJob != null || this.poll())) {
            this.currentJob.execute(runner);
            switch (this.currentJob.schedulingState) {
                case TERMINATED: {
                    ActorJob terminatedJob = this.currentJob;
                    this.currentJob = this.fastLaneJobs.poll();
                    if (terminatedJob.isTriggeredBySubscription()) {
                        ActorSubscription subscription = terminatedJob.getSubscription();
                        if (!subscription.isRecurring()) {
                            this.removeSubscription(subscription);
                        }
                        subscription.onJobCompleted();
                        break;
                    }
                    runner.recycleJob(terminatedJob);
                    break;
                }
                case QUEUED: {
                    resubmit = true;
                    break;
                }
            }
            if (!this.shouldYield) continue;
            this.shouldYield = false;
            boolean bl = resubmit = this.currentJob != null;
            break;
        }
        if (this.currentJob == null) {
            resubmit = this.onAllJobsDone();
        }
        return resubmit;
    }

    private boolean onAllJobsDone() {
        boolean resubmit = false;
        if (this.allPhaseSubscriptionsTriggered()) {
            switch (this.lifecyclePhase) {
                case STARTING: {
                    this.lifecyclePhase = ActorLifecyclePhase.STARTED;
                    this.submitStartedJob();
                    this.startingFuture.completeWith(this.jobStartingTaskFuture);
                    resubmit = true;
                    break;
                }
                case CLOSING: {
                    this.lifecyclePhase = ActorLifecyclePhase.CLOSED;
                    this.submitClosedJob();
                    resubmit = true;
                    break;
                }
                case STARTED: {
                    resubmit = this.tryWait();
                    break;
                }
                case CLOSE_REQUESTED: {
                    this.lifecyclePhase = ActorLifecyclePhase.CLOSING;
                    this.submitClosingJob();
                    resubmit = true;
                    break;
                }
                case CLOSED: {
                    this.onClosed();
                    this.closeFuture.completeWith(this.jobClosingTaskFuture);
                    resubmit = false;
                    break;
                }
                case FAILED: {
                    this.onClosed();
                    resubmit = false;
                }
            }
        } else if (this.lifecyclePhase != ActorLifecyclePhase.CLOSED) {
            resubmit = this.tryWait();
        }
        return resubmit;
    }

    private void submitStartedJob() {
        ActorJob startedJob = ActorThread.current().newJob();
        startedJob.onJobAddedToTask(this);
        startedJob.setAutoCompleting(true);
        startedJob.setRunnable(this.actor::onActorStarted);
        this.currentJob = startedJob;
    }

    private void submitClosedJob() {
        ActorJob closedJob = ActorThread.current().newJob();
        closedJob.onJobAddedToTask(this);
        closedJob.setAutoCompleting(true);
        closedJob.setRunnable(this.actor::onActorClosed);
        this.currentJob = closedJob;
    }

    private void submitClosingJob() {
        ActorJob closeJob = ActorThread.current().newJob();
        closeJob.onJobAddedToTask(this);
        closeJob.setAutoCompleting(true);
        closeJob.setRunnable(this.actor::onActorClosing);
        closeJob.setResultFuture(this.jobClosingTaskFuture);
        this.currentJob = closeJob;
    }

    private void onClosed() {
        ActorJob j;
        this.schedulingState = TaskSchedulingState.NOT_SCHEDULED;
        for (int i = 0; i < this.subscriptions.length; ++i) {
            this.subscriptions[i].cancel();
        }
        this.subscriptions = new ActorSubscription[0];
        Queue<ActorJob> activeJobsQueue = this.submittedJobs;
        this.submittedJobs = new ClosedQueue();
        while ((j = activeJobsQueue.poll()) != null) {
            this.failJob(j);
        }
    }

    private void failJob(ActorJob job) {
        try {
            job.failFuture("Actor is closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void requestClose() {
        if (this.lifecyclePhase == ActorLifecyclePhase.STARTED) {
            this.lifecyclePhase = ActorLifecyclePhase.CLOSE_REQUESTED;
            this.discardNextJobs();
            this.actor.onActorCloseRequested();
        }
    }

    public void onFailure(Throwable failure) {
        switch (this.lifecyclePhase) {
            case STARTING: {
                Loggers.ACTOR_LOGGER.error("Actor failed in phase 'STARTING'. Discard all jobs and stop immediatly.", failure);
                this.lifecyclePhase = ActorLifecyclePhase.FAILED;
                this.discardNextJobs();
                this.startingFuture.completeExceptionally(failure);
                break;
            }
            case CLOSING: {
                Loggers.ACTOR_LOGGER.error("Actor failed in phase 'CLOSING'. Discard all jobs and stop immediatly.", failure);
                this.lifecyclePhase = ActorLifecyclePhase.FAILED;
                this.discardNextJobs();
                this.closeFuture.completeExceptionally(failure);
                break;
            }
            default: {
                Loggers.ACTOR_LOGGER.error("Actor failed in phase '{}'. Continue with next job.", (Object)this.lifecyclePhase, (Object)failure);
                this.currentJob.failFuture(failure);
            }
        }
    }

    private void discardNextJobs() {
        ActorJob next;
        while ((next = this.fastLaneJobs.poll()) != null) {
            this.failJob(next);
        }
    }

    boolean casStateCount(long expectedCount) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, STATE_COUNT_OFFSET, expectedCount, expectedCount + 1L);
    }

    boolean casState(TaskSchedulingState expectedState, TaskSchedulingState newState) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, SCHEDULING_STATE_OFFSET, (Object)expectedState, (Object)newState);
    }

    public boolean claim(long stateCount) {
        return this.casStateCount(stateCount);
    }

    boolean tryWait() {
        ActorSubscription[] subscriptionsCopy = this.subscriptions;
        this.schedulingState = TaskSchedulingState.WAITING;
        return (this.lifecyclePhase == ActorLifecyclePhase.STARTED && !this.submittedJobs.isEmpty() || this.pollSubscriptionsWithoutAddingJobs(subscriptionsCopy)) && this.casState(TaskSchedulingState.WAITING, TaskSchedulingState.WAKING_UP);
    }

    public boolean tryWakeup() {
        boolean didWakeup = false;
        if (this.casState(TaskSchedulingState.WAITING, TaskSchedulingState.WAKING_UP)) {
            this.resubmit();
            didWakeup = true;
        }
        return didWakeup;
    }

    private boolean poll() {
        boolean result = false;
        result |= this.pollSubmittedJobs();
        return result |= this.pollSubscriptions();
    }

    private boolean pollSubscriptions() {
        boolean hasJobs = false;
        for (int i = 0; i < this.subscriptions.length; ++i) {
            ActorSubscription subscription = this.subscriptions[i];
            if (!this.pollSubscription(subscription)) continue;
            ActorJob job = subscription.getJob();
            job.schedulingState = TaskSchedulingState.QUEUED;
            if (this.currentJob == null) {
                this.currentJob = job;
            } else {
                this.fastLaneJobs.offer(job);
            }
            hasJobs = true;
        }
        return hasJobs;
    }

    private boolean pollSubscription(ActorSubscription subscription) {
        return subscription.triggersInPhase(this.lifecyclePhase) && subscription.poll();
    }

    private boolean pollSubscriptionsWithoutAddingJobs(ActorSubscription[] subscriptions) {
        boolean result = false;
        for (int i = 0; i < subscriptions.length && !result; result |= this.pollSubscription(subscriptions[i]), ++i) {
        }
        return result;
    }

    private boolean allPhaseSubscriptionsTriggered() {
        ActorSubscription subscription;
        boolean allTriggered = true;
        for (int i = 0; i < this.subscriptions.length && allTriggered; allTriggered &= !(subscription = this.subscriptions[i]).triggersInPhase(this.lifecyclePhase), ++i) {
        }
        return allTriggered;
    }

    private boolean pollSubmittedJobs() {
        boolean hasJobs = false;
        while (this.lifecyclePhase == ActorLifecyclePhase.STARTED && !this.submittedJobs.isEmpty()) {
            ActorJob job = this.submittedJobs.poll();
            if (job == null) continue;
            if (this.currentJob == null) {
                this.currentJob = job;
            } else {
                this.fastLaneJobs.offer(job);
            }
            hasJobs = true;
        }
        return hasJobs;
    }

    public TaskSchedulingState getState() {
        return this.schedulingState;
    }

    public String toString() {
        return this.actor.getName() + " " + (Object)((Object)this.schedulingState) + " phase: " + (Object)((Object)this.lifecyclePhase);
    }

    public void yield() {
        this.shouldYield = true;
    }

    public long getStateCount() {
        return this.stateCount;
    }

    public ActorThreadGroup getActorThreadGroup() {
        return this.actorThreadGroup;
    }

    public String getName() {
        return this.actor.getName();
    }

    public Actor getActor() {
        return this.actor;
    }

    public boolean isClosing() {
        return this.lifecyclePhase == ActorLifecyclePhase.CLOSING;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ActorExecutor getActorExecutor() {
        return this.actorExecutor;
    }

    public ActorLifecyclePhase getLifecyclePhase() {
        return this.lifecyclePhase;
    }

    public CompletableActorFuture<Void> getStartingFuture() {
        return this.startingFuture;
    }

    public void addSubscription(ActorSubscription subscription) {
        ActorSubscription[] arrayCopy = Arrays.copyOf(this.subscriptions, this.subscriptions.length + 1);
        arrayCopy[arrayCopy.length - 1] = subscription;
        this.subscriptions = arrayCopy;
    }

    private void removeSubscription(ActorSubscription subscription) {
        int length = this.subscriptions.length;
        int index = -1;
        for (int i = 0; i < this.subscriptions.length; ++i) {
            if (this.subscriptions[i] != subscription) continue;
            index = i;
        }
        assert (index >= 0) : "Subscription not registered";
        ActorSubscription[] newSubscriptions = new ActorSubscription[length - 1];
        System.arraycopy(this.subscriptions, 0, newSubscriptions, 0, index);
        if (index < length - 1) {
            System.arraycopy(this.subscriptions, index + 1, newSubscriptions, index, length - index - 1);
        }
        this.subscriptions = newSubscriptions;
    }

    public void onSubscriptionCancelled(ActorSubscription subscription) {
        if (this.lifecyclePhase != ActorLifecyclePhase.CLOSED) {
            this.removeSubscription(subscription);
        }
    }

    public void setUpdatedSchedulingHints(int hints) {
        if (SchedulingHints.isCpuBound(hints)) {
            this.priority = SchedulingHints.getPriority(hints);
            this.actorThreadGroup = this.actorExecutor.getCpuBoundThreads();
        } else {
            this.actorThreadGroup = this.actorExecutor.getIoBoundThreads();
        }
    }

    public void resubmit() {
        this.actorThreadGroup.submit(this);
    }

    public void insertJob(ActorJob job) {
        this.fastLaneJobs.addFirst(job);
    }

    static {
        try {
            STATE_COUNT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ActorTask.class.getDeclaredField("stateCount"));
            SCHEDULING_STATE_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ActorTask.class.getDeclaredField("schedulingState"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ActorLifecyclePhase {
        STARTING(1),
        STARTED(2),
        CLOSE_REQUESTED(4),
        CLOSING(8),
        CLOSED(16),
        FAILED(32);

        private final int value;

        private ActorLifecyclePhase(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TaskSchedulingState {
        NOT_SCHEDULED,
        ACTIVE,
        QUEUED,
        WAITING,
        WAKING_UP,
        TERMINATED;

    }
}

