/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.ActorTask;
import io.zeebe.util.sched.ActorThreadGroup;
import io.zeebe.util.sched.future.ActorFuture;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ActorExecutor {
    private final ActorThreadGroup cpuBoundThreads;
    private final ActorThreadGroup ioBoundThreads;
    private final ThreadPoolExecutor blockingTasksRunner;
    private Duration blockingTasksShutdownTime;

    public ActorExecutor(ActorScheduler.ActorSchedulerBuilder builder) {
        this.ioBoundThreads = builder.getIoBoundActorThreads();
        this.cpuBoundThreads = builder.getCpuBoundActorThreads();
        this.blockingTasksRunner = builder.getBlockingTasksRunner();
        this.blockingTasksShutdownTime = builder.getBlockingTasksShutdownTime();
    }

    public ActorFuture<Void> submitCpuBound(ActorTask task) {
        return this.submitTask(task, this.cpuBoundThreads);
    }

    public ActorFuture<Void> submitIoBoundTask(ActorTask task) {
        return this.submitTask(task, this.ioBoundThreads);
    }

    private ActorFuture<Void> submitTask(ActorTask task, ActorThreadGroup threadGroup) {
        ActorFuture<Void> startingFuture = task.onTaskScheduled(this, threadGroup);
        threadGroup.submit(task);
        return startingFuture;
    }

    public void submitBlocking(Runnable action) {
        this.blockingTasksRunner.execute(action);
    }

    public void start() {
        this.cpuBoundThreads.start();
        this.ioBoundThreads.start();
    }

    public CompletableFuture<Void> closeAsync() {
        this.blockingTasksRunner.shutdown();
        CompletableFuture<Void> resultFuture = CompletableFuture.allOf(this.ioBoundThreads.closeAsync(), this.cpuBoundThreads.closeAsync());
        try {
            this.blockingTasksRunner.awaitTermination(this.blockingTasksShutdownTime.getSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return resultFuture;
    }

    public ActorThreadGroup getCpuBoundThreads() {
        return this.cpuBoundThreads;
    }

    public ActorThreadGroup getIoBoundThreads() {
        return this.ioBoundThreads;
    }

    public Duration getBlockingTasksShutdownTime() {
        return this.blockingTasksShutdownTime;
    }

    public void setBlockingTasksShutdownTime(Duration duration) {
        this.blockingTasksShutdownTime = duration;
    }
}

