/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.retry;

import io.zeebe.util.retry.OperationToRetry;
import io.zeebe.util.retry.RetryStrategy;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;
import java.util.function.BooleanSupplier;

public class BackOffRetryStrategy
implements RetryStrategy {
    private final ActorControl actor;
    private final Duration maxBackOff;
    private Duration backOffDuration;
    private CompletableActorFuture<Boolean> currentFuture;
    private BooleanSupplier currentTerminateCondition;
    private OperationToRetry currentCallable;

    public BackOffRetryStrategy(ActorControl actor, Duration maxBackOff) {
        this.actor = actor;
        this.maxBackOff = maxBackOff;
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable) {
        return this.runWithRetry(callable, () -> false);
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable, BooleanSupplier terminateCondition) {
        this.currentFuture = new CompletableActorFuture();
        this.currentTerminateCondition = terminateCondition;
        this.currentCallable = callable;
        this.backOffDuration = Duration.ofSeconds(1L);
        this.actor.run(this::run);
        return this.currentFuture;
    }

    private void run() {
        try {
            if (this.currentCallable.run()) {
                this.currentFuture.complete(true);
            } else if (this.currentTerminateCondition.getAsBoolean()) {
                this.currentFuture.complete(false);
            } else {
                this.backOff();
            }
        }
        catch (Exception exception) {
            if (this.currentTerminateCondition.getAsBoolean()) {
                this.currentFuture.complete(false);
            }
            this.backOff();
        }
    }

    private void backOff() {
        boolean notReachedMaxBackOff;
        boolean bl = notReachedMaxBackOff = !this.backOffDuration.equals(this.maxBackOff);
        if (notReachedMaxBackOff) {
            Duration nextBackOff = this.backOffDuration.multipliedBy(2L);
            this.backOffDuration = nextBackOff.compareTo(this.maxBackOff) < 0 ? nextBackOff : this.maxBackOff;
        }
        this.actor.runDelayed(this.backOffDuration, this::run);
    }
}

