/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.retry;

import io.zeebe.util.retry.OperationToRetry;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.function.BooleanSupplier;

public class ActorRetryMechanism {
    private final ActorControl actor;
    private OperationToRetry currentCallable;
    private BooleanSupplier currentTerminateCondition;
    private ActorFuture<Boolean> currentFuture;

    public ActorRetryMechanism(ActorControl actor) {
        this.actor = actor;
    }

    void wrap(OperationToRetry callable, BooleanSupplier condition, ActorFuture<Boolean> resultFuture) {
        this.currentCallable = callable;
        this.currentTerminateCondition = condition;
        this.currentFuture = resultFuture;
    }

    void run() throws Exception {
        if (this.currentCallable.run()) {
            this.currentFuture.complete(true);
            this.actor.done();
        } else if (this.currentTerminateCondition.getAsBoolean()) {
            this.currentFuture.complete(false);
            this.actor.done();
        } else {
            this.actor.yield();
        }
    }
}

