/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class StringUtil {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static byte[] getBytes(String value) {
        return StringUtil.getBytes(value, DEFAULT_CHARSET);
    }

    public static byte[] getBytes(String value, Charset charset) {
        return value.getBytes(charset);
    }

    public static String fromBytes(byte[] bytes) {
        return StringUtil.fromBytes(bytes, DEFAULT_CHARSET);
    }

    public static String fromBytes(byte[] bytes, Charset charset) {
        return new String(bytes, charset);
    }

    public static String formatStackTrace(StackTraceElement[] trace) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : trace) {
            sb.append("\t");
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String stringOfLength(int length) {
        char[] chars = new char[length];
        Arrays.fill(chars, 'a');
        return new String(chars);
    }
}

