/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class DurationUtil {
    public static Duration parse(String durationString) {
        long value;
        ChronoUnit unit;
        String matchedUnit = DurationUtil.extractUnit(durationString);
        String matchedValue = durationString.substring(0, durationString.length() - matchedUnit.length());
        if (matchedValue.isEmpty()) {
            throw new IllegalArgumentException("no value given; expected format: [value][unit], e.g. '1s', '1.5ms'");
        }
        switch (matchedUnit) {
            case "ms": 
            case "": {
                unit = ChronoUnit.MICROS;
                value = (long)(Float.parseFloat(matchedValue) * 1000.0f);
                break;
            }
            case "s": {
                unit = ChronoUnit.MILLIS;
                value = (long)(Float.parseFloat(matchedValue) * 1000.0f);
                break;
            }
            case "m": {
                unit = ChronoUnit.SECONDS;
                value = (long)(Float.parseFloat(matchedValue) * 60.0f);
                break;
            }
            case "h": {
                unit = ChronoUnit.MINUTES;
                value = (long)(Float.parseFloat(matchedValue) * 60.0f);
                break;
            }
            default: {
                String errorMessage = String.format("unknown unit %s; must be one of: ms, s, m, h", matchedUnit);
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return Duration.of(value, unit);
    }

    private static String extractUnit(CharSequence humanReadable) {
        char current;
        StringBuilder unitBuilder = new StringBuilder();
        for (int i = humanReadable.length() - 1; i >= 0 && Character.isAlphabetic(current = humanReadable.charAt(i)); --i) {
            unitBuilder.append(current);
        }
        return unitBuilder.reverse().toString();
    }
}

