/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import io.zeebe.util.ByteUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByteValue {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)([K|M|G]?)", 2);
    private final ByteUnit unit;
    private final long value;

    public ByteValue(long value, ByteUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public static ByteValue ofBytes(long value) {
        return new ByteValue(value, ByteUnit.BYTES);
    }

    public static ByteValue ofKilobytes(long value) {
        return new ByteValue(value, ByteUnit.KILOBYTES);
    }

    public static ByteValue ofMegabytes(long value) {
        return new ByteValue(value, ByteUnit.MEGABYTES);
    }

    public static ByteValue ofGigabytes(long value) {
        return new ByteValue(value, ByteUnit.GIGABYTES);
    }

    public ByteValue(String humanReadable) {
        Matcher matcher = PATTERN.matcher(humanReadable);
        if (!matcher.matches()) {
            String err = String.format("Illegal byte value '%s'. Must match '%s'. Valid examples: 100M, 4K, ...", humanReadable, PATTERN.pattern());
            throw new IllegalArgumentException(err);
        }
        String valueString = matcher.group(1);
        this.value = Long.parseLong(valueString);
        String unitString = matcher.group(2).toUpperCase();
        this.unit = ByteUnit.getUnit(unitString);
    }

    public ByteUnit getUnit() {
        return this.unit;
    }

    public long getValue() {
        return this.value;
    }

    public long toBytes() {
        return this.unit.toBytes(this.value);
    }

    public ByteValue toBytesValue() {
        return new ByteValue(this.unit.toBytes(this.value), ByteUnit.BYTES);
    }

    public ByteValue toKilobytesValue() {
        return new ByteValue(this.unit.toKilobytes(this.value), ByteUnit.KILOBYTES);
    }

    public ByteValue toMegabytesValue() {
        return new ByteValue(this.unit.toMegabytes(this.value), ByteUnit.MEGABYTES);
    }

    public ByteValue toGigabytesValue() {
        return new ByteValue(this.unit.toGigabytes(this.value), ByteUnit.GIGABYTES);
    }

    public String toString() {
        return String.format("%d%s", this.value, this.unit.metric());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteValue other = (ByteValue)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return this.value == other.value;
    }
}

