/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.query;

import io.zeebe.msgpack.query.MsgPackTokenVisitor;
import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackToken;
import org.agrona.DirectBuffer;

public class MsgPackTraverser {
    protected static final int NO_INVALID_POSITION = -1;
    protected String errorMessage;
    protected int invalidPosition;
    protected MsgPackReader msgPackReader = new MsgPackReader();

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.msgPackReader.wrap(buffer, offset, length);
        this.invalidPosition = -1;
        this.errorMessage = null;
    }

    public void reset() {
        this.msgPackReader.reset();
        this.invalidPosition = -1;
        this.errorMessage = null;
    }

    public boolean traverse(MsgPackTokenVisitor visitor) {
        while (this.msgPackReader.hasNext()) {
            MsgPackToken nextToken;
            int nextTokenPosition = this.msgPackReader.getOffset();
            try {
                nextToken = this.msgPackReader.readToken();
            }
            catch (Exception e) {
                this.errorMessage = e.getMessage();
                this.invalidPosition = nextTokenPosition;
                return false;
            }
            visitor.visitElement(nextTokenPosition, nextToken);
        }
        return true;
    }

    public int getInvalidPosition() {
        return this.invalidPosition;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

