/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.mapping;

import io.zeebe.msgpack.mapping.Mapping;
import io.zeebe.msgpack.mapping.MsgPackDiff;
import io.zeebe.msgpack.mapping.MsgPackTree;
import io.zeebe.msgpack.mapping.MsgPackTreeNodeIdConstructor;
import io.zeebe.msgpack.spec.MsgPackWriter;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MappingDiff
implements MsgPackDiff {
    public static final DirectBuffer CONSTANTS_DOCUMENT;
    private static final int RESULT_ENTRY_LENGTH = 9;
    private Mapping[] mappings;
    private DirectBuffer document;
    private final ExpandableArrayBuffer mappingResults = new ExpandableArrayBuffer();

    public void init(Mapping[] mappings, DirectBuffer document) {
        this.mappings = mappings;
        this.document = document;
    }

    public int getResultOffset(int mappingIndex) {
        return this.mappingResults.getInt(MappingDiff.mapToResultIndex(mappingIndex));
    }

    public int getResultLength(int mappingIndex) {
        return this.mappingResults.getInt(MappingDiff.mapToResultIndex(mappingIndex) + 4);
    }

    public boolean isMappedFromSourceDocument(int mappingIndex) {
        return this.mappingResults.getByte(MappingDiff.mapToResultIndex(mappingIndex) + 8) == 1;
    }

    private static int mapToResultIndex(int mappingIndex) {
        return mappingIndex * 9;
    }

    public void setResult(int mappingIndex, int offset, int length) {
        this.setResult(mappingIndex, offset, length, true);
    }

    public void setNullResult(int mappingIndex) {
        this.setResult(mappingIndex, 1, 1, false);
    }

    public void setEmptyMapResult(int mappingIndex) {
        this.setResult(mappingIndex, 0, 1, false);
    }

    private void setResult(int mappingIndex, int offset, int length, boolean fromSourceDocument) {
        int mappingResultOffset = MappingDiff.mapToResultIndex(mappingIndex);
        this.mappingResults.putInt(mappingResultOffset, offset);
        this.mappingResults.putInt(mappingResultOffset += 4, length);
        this.mappingResults.putByte(mappingResultOffset += 4, fromSourceDocument ? (byte)1 : 0);
    }

    private boolean isIndex(String nodeName) {
        int len = nodeName.length();
        for (int i = 0; i < len; ++i) {
            char currentChar = nodeName.charAt(i);
            if (currentChar >= '0' && currentChar <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public void mergeInto(MsgPackTree document) {
        int constantsDocumentId = document.addDocument(CONSTANTS_DOCUMENT);
        int ourDocumentId = document.addDocument(this.document);
        for (int i = 0; i < this.mappings.length; ++i) {
            Mapping mapping = this.mappings[i];
            String[] targetPathElements = mapping.getTargetPointer().getPathElements();
            String parentId = "";
            for (int j = 0; j < targetPathElements.length; ++j) {
                String nodeName = targetPathElements[j];
                if (j == targetPathElements.length - 1) {
                    int valueOffset = this.getResultOffset(i);
                    int valueLength = this.getResultLength(i);
                    int documentId = this.isMappedFromSourceDocument(i) ? ourDocumentId : constantsDocumentId;
                    this.mergeValueInto(document, parentId, nodeName, mapping.getType(), documentId, valueOffset, valueLength);
                    continue;
                }
                parentId = this.mergeContainerInto(document, parentId, nodeName, targetPathElements[j + 1]);
            }
        }
    }

    private String mergeContainerInto(MsgPackTree document, String parentId, String nodeName, String nextPathElement) {
        String nodeId = MsgPackTreeNodeIdConstructor.construct(parentId, nodeName);
        if (document.hasNode(nodeId)) {
            if (!this.isIndex(nextPathElement)) {
                document.convertToMapNode(nodeId);
            }
            return nodeId;
        }
        if (this.isIndex(nextPathElement)) {
            return document.addArrayNode(parentId, nodeName);
        }
        return document.addMapNode(parentId, nodeName);
    }

    private void mergeValueInto(MsgPackTree document, String parentId, String nodeName, Mapping.Type mappingType, int documentId, int valueOffset, int valueLength) {
        switch (mappingType) {
            case COLLECT: {
                document.appendToArray(parentId, nodeName, documentId, valueOffset, valueLength);
                break;
            }
            default: {
                document.addValueNode(parentId, nodeName, documentId, valueOffset, valueLength);
            }
        }
    }

    static {
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[2]);
        MsgPackWriter writer = new MsgPackWriter();
        writer.wrap((MutableDirectBuffer)buffer, 0);
        writer.writeMapHeader(0);
        writer.writeNil();
        CONSTANTS_DOCUMENT = buffer;
    }
}

