/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.mapping;

import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.jsonpath.JsonPathQueryCompiler;
import io.zeebe.msgpack.mapping.JsonPathPointer;
import io.zeebe.msgpack.mapping.Mapping;
import java.util.ArrayList;
import java.util.List;

public class MappingBuilder {
    private final JsonPathQueryCompiler queryCompiler = new JsonPathQueryCompiler();
    private List<Mapping> mappings = new ArrayList<Mapping>();

    public static Mapping[] createMapping(String source, String target) {
        return MappingBuilder.createMappings().mapping(source, target).build();
    }

    public static Mapping[] createMapping(String source, String target, Mapping.Type type) {
        return MappingBuilder.createMappings().mapping(source, target, type).build();
    }

    protected static MappingBuilder createMappings() {
        return new MappingBuilder();
    }

    public MappingBuilder mapping(String source, String target) {
        return this.mapping(source, target, Mapping.Type.PUT);
    }

    public MappingBuilder mapping(String source, String target, Mapping.Type type) {
        JsonPathQuery sourceQuery = this.queryCompiler.compile(source);
        String targetPath = "$." + target;
        JsonPathPointer targetPointer = new JsonPathPointer(targetPath.split("\\."));
        this.mappings.add(new Mapping(sourceQuery, targetPointer, type));
        return this;
    }

    public Mapping[] build() {
        Mapping[] result = this.mappings.toArray(new Mapping[this.mappings.size()]);
        this.mappings.clear();
        return result;
    }
}

