/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.state;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class StateStorage {
    static final String TMP_SNAPSHOT_DIRECTORY = "tmp/";
    private static final String DEFAULT_RUNTIME_DIRECTORY = "runtime";
    private static final String DEFAULT_SNAPSHOTS_DIRECTORY = "snapshots";
    private final File runtimeDirectory;
    private final File snapshotsDirectory;
    private String tmpSuffix = "-tmp";
    private File tmpSnapshotDirectory;

    public StateStorage(String rootDirectory) {
        this.runtimeDirectory = new File(rootDirectory, DEFAULT_RUNTIME_DIRECTORY);
        this.snapshotsDirectory = new File(rootDirectory, DEFAULT_SNAPSHOTS_DIRECTORY);
        this.initTempSnapshotDirectory();
    }

    public StateStorage(File runtimeDirectory, File snapshotsDirectory) {
        this.runtimeDirectory = runtimeDirectory;
        this.snapshotsDirectory = snapshotsDirectory;
        this.initTempSnapshotDirectory();
    }

    public StateStorage(File runtimeDirectory, File snapshotsDirectory, String tmpSuffix) {
        this(runtimeDirectory, snapshotsDirectory);
        this.tmpSuffix = tmpSuffix;
    }

    private void initTempSnapshotDirectory() {
        this.tmpSnapshotDirectory = new File(this.snapshotsDirectory, TMP_SNAPSHOT_DIRECTORY);
    }

    public File getRuntimeDirectory() {
        return this.runtimeDirectory;
    }

    public File getSnapshotsDirectory() {
        return this.snapshotsDirectory;
    }

    public File getTmpSnapshotDirectoryFor(String position) {
        String path = String.format("%s%s", position, this.tmpSuffix);
        return new File(this.snapshotsDirectory, path);
    }

    public boolean existSnapshot(long snapshotPosition) {
        File[] files = this.snapshotsDirectory.listFiles();
        if (files != null && files.length > 0) {
            String snapshotDirName = Long.toString(snapshotPosition);
            return Arrays.stream(files).anyMatch(f -> f.getName().equalsIgnoreCase(snapshotDirName));
        }
        return false;
    }

    public File getSnapshotDirectoryFor(long position) {
        String path = String.format("%d", position);
        return new File(this.snapshotsDirectory, path);
    }

    public File getTempSnapshotDirectory() {
        return this.tmpSnapshotDirectory;
    }

    public List<File> list() {
        File[] snapshotFolders = this.snapshotsDirectory.listFiles();
        if (snapshotFolders == null || snapshotFolders.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(snapshotFolders).filter(File::isDirectory).filter(f -> this.isNumber(f.getName())).collect(Collectors.toList());
    }

    private boolean isNumber(String name) {
        try {
            Long.parseLong(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<File> listByPositionAsc() {
        return this.list().stream().sorted(Comparator.comparingLong(f -> Long.parseLong(f.getName()))).collect(Collectors.toList());
    }

    public List<File> listByPositionDesc() {
        List<File> list = this.listByPositionAsc();
        Collections.reverse(list);
        return list;
    }

    private String getPositionFromFileName(File file) {
        return file.getName().split(this.tmpSuffix)[0];
    }

    public List<File> findTmpDirectoriesBelowPosition(long position) {
        File[] snapshotFolders = this.snapshotsDirectory.listFiles();
        if (snapshotFolders == null || snapshotFolders.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(snapshotFolders).filter(File::isDirectory).filter(f -> f.getName().endsWith(this.tmpSuffix)).filter(f -> {
            String positionFromFileName = this.getPositionFromFileName((File)f);
            return this.isNumber(positionFromFileName) && Long.parseLong(positionFromFileName) < position;
        }).collect(Collectors.toList());
    }
}

