/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.state;

import io.zeebe.logstreams.state.SnapshotChunk;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.zip.CRC32;

public class SnapshotChunkUtil {
    public static long createChecksum(byte[] content) {
        CRC32 crc32 = new CRC32();
        crc32.update(content);
        return crc32.getValue();
    }

    public static SnapshotChunk createSnapshotChunkFromFile(File snapshotChunkFile, long snapshotPosition, int totalCount) throws IOException {
        byte[] content = Files.readAllBytes(snapshotChunkFile.toPath());
        long checksum = SnapshotChunkUtil.createChecksum(content);
        return new SnapshotChunkImpl(snapshotPosition, totalCount, snapshotChunkFile.getName(), checksum, content);
    }

    private static final class SnapshotChunkImpl
    implements SnapshotChunk {
        private final long snapshotPosition;
        private final int totalCount;
        private final String chunkName;
        private final byte[] content;
        private final long checksum;

        SnapshotChunkImpl(long snapshotPosition, int totalCount, String chunkName, long checksum, byte[] content) {
            this.snapshotPosition = snapshotPosition;
            this.totalCount = totalCount;
            this.chunkName = chunkName;
            this.checksum = checksum;
            this.content = content;
        }

        @Override
        public long getSnapshotPosition() {
            return this.snapshotPosition;
        }

        @Override
        public int getTotalCount() {
            return this.totalCount;
        }

        @Override
        public String getChunkName() {
            return this.chunkName;
        }

        @Override
        public long getChecksum() {
            return this.checksum;
        }

        @Override
        public byte[] getContent() {
            return this.content;
        }
    }
}

