/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.log;

import io.zeebe.dispatcher.ClaimedFragmentBatch;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import io.zeebe.logstreams.impl.LogEntryDescriptor;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamBatchWriter;
import io.zeebe.protocol.Protocol;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.buffer.DirectBufferWriter;
import io.zeebe.util.sched.clock.ActorClock;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;

public class LogStreamBatchWriterImpl
implements LogStreamBatchWriter,
LogStreamBatchWriter.LogEntryBuilder {
    private static final int INITIAL_BUFFER_CAPACITY = 32768;
    private final ClaimedFragmentBatch claimedBatch = new ClaimedFragmentBatch();
    private final MutableDirectBuffer eventBuffer = new ExpandableDirectByteBuffer(32768);
    private final DirectBufferWriter metadataWriterInstance = new DirectBufferWriter();
    private final DirectBufferWriter bufferWriterInstance = new DirectBufferWriter();
    private int eventBufferOffset;
    private int eventLength;
    private int eventCount;
    private Dispatcher logWriteBuffer;
    private int logId;
    private long key;
    private long sourceEventPosition;
    private int sourceIndex;
    private BufferWriter metadataWriter;
    private BufferWriter valueWriter;

    public LogStreamBatchWriterImpl(LogStream logStream) {
        this.wrap(logStream);
    }

    @Override
    public void wrap(LogStream logStream) {
        this.logWriteBuffer = logStream.getWriteBuffer();
        this.logId = logStream.getPartitionId();
        this.reset();
    }

    @Override
    public LogStreamBatchWriter sourceRecordPosition(long position) {
        this.sourceEventPosition = position;
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder event() {
        this.copyExistingEventToBuffer();
        this.resetEvent();
        return this;
    }

    @Override
    public void reset() {
        this.eventBufferOffset = 0;
        this.eventLength = 0;
        this.eventCount = 0;
        this.sourceEventPosition = -1L;
        this.resetEvent();
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder keyNull() {
        return this.key(-1L);
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder key(long key) {
        this.key = key;
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder sourceIndex(int index) {
        this.sourceIndex = index;
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder metadata(DirectBuffer buffer, int offset, int length) {
        this.metadataWriterInstance.wrap(buffer, offset, length);
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder metadata(DirectBuffer buffer) {
        return this.metadata(buffer, 0, buffer.capacity());
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder metadataWriter(BufferWriter writer) {
        this.metadataWriter = writer;
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder value(DirectBuffer value, int valueOffset, int valueLength) {
        return this.valueWriter((BufferWriter)this.bufferWriterInstance.wrap(value, valueOffset, valueLength));
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder value(DirectBuffer value) {
        return this.value(value, 0, value.capacity());
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder valueWriter(BufferWriter writer) {
        this.valueWriter = writer;
        return this;
    }

    @Override
    public LogStreamBatchWriter done() {
        EnsureUtil.ensureNotNull((String)"value", (Object)this.valueWriter);
        this.copyExistingEventToBuffer();
        this.resetEvent();
        return this;
    }

    public void copyExistingEventToBuffer() {
        if (this.valueWriter == null) {
            return;
        }
        int metadataLength = this.metadataWriter.getLength();
        int valueLength = this.valueWriter.getLength();
        this.eventBuffer.putLong(this.eventBufferOffset, this.key, Protocol.ENDIANNESS);
        this.eventBufferOffset += 8;
        this.eventBuffer.putInt(this.eventBufferOffset, this.sourceIndex, Protocol.ENDIANNESS);
        this.eventBufferOffset += 4;
        this.eventBuffer.putInt(this.eventBufferOffset, metadataLength, Protocol.ENDIANNESS);
        this.eventBufferOffset += 4;
        this.eventBuffer.putInt(this.eventBufferOffset, valueLength, Protocol.ENDIANNESS);
        this.eventBufferOffset += 4;
        if (metadataLength > 0) {
            this.metadataWriter.write(this.eventBuffer, this.eventBufferOffset);
            this.eventBufferOffset += metadataLength;
        }
        this.valueWriter.write(this.eventBuffer, this.eventBufferOffset);
        this.eventBufferOffset += valueLength;
        this.eventLength += metadataLength + valueLength;
        ++this.eventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryWrite() {
        long result;
        if (this.eventCount == 0) {
            if (this.valueWriter == null) {
                return 0L;
            }
            this.copyExistingEventToBuffer();
        }
        if ((result = this.claimBatchForEvents()) >= 0L) {
            try {
                result = this.writeEventsToBuffer(this.claimedBatch.getBuffer());
                this.claimedBatch.commit();
            }
            catch (Exception e) {
                this.claimedBatch.abort();
                LangUtil.rethrowUnchecked((Throwable)e);
            }
            finally {
                this.reset();
            }
        }
        return result;
    }

    private long claimBatchForEvents() {
        int batchLength = this.eventLength + this.eventCount * LogEntryDescriptor.HEADER_BLOCK_LENGTH;
        long claimedPosition = -1L;
        while ((claimedPosition = this.logWriteBuffer.claim(this.claimedBatch, this.eventCount, batchLength)) == -2L) {
        }
        return claimedPosition;
    }

    private long writeEventsToBuffer(MutableDirectBuffer writeBuffer) {
        long lastEventPosition = -1L;
        this.eventBufferOffset = 0;
        long[] positions = new long[this.eventCount];
        for (int i = 0; i < this.eventCount; ++i) {
            long position;
            long key = this.eventBuffer.getLong(this.eventBufferOffset, Protocol.ENDIANNESS);
            this.eventBufferOffset += 8;
            int sourceIndex = this.eventBuffer.getInt(this.eventBufferOffset, Protocol.ENDIANNESS);
            this.eventBufferOffset += 4;
            int metadataLength = this.eventBuffer.getInt(this.eventBufferOffset, Protocol.ENDIANNESS);
            this.eventBufferOffset += 4;
            int valueLength = this.eventBuffer.getInt(this.eventBufferOffset, Protocol.ENDIANNESS);
            this.eventBufferOffset += 4;
            int fragmentLength = LogEntryDescriptor.headerLength(metadataLength) + valueLength;
            long nextFragmentPosition = this.claimedBatch.nextFragment(fragmentLength, this.logId);
            int bufferOffset = this.claimedBatch.getFragmentOffset();
            positions[i] = position = nextFragmentPosition - (long)DataFrameDescriptor.alignedFramedLength((int)fragmentLength);
            LogEntryDescriptor.setPosition(writeBuffer, bufferOffset, position);
            if (sourceIndex >= 0 && sourceIndex < i) {
                LogEntryDescriptor.setSourceEventPosition(writeBuffer, bufferOffset, positions[sourceIndex]);
            } else {
                LogEntryDescriptor.setSourceEventPosition(writeBuffer, bufferOffset, this.sourceEventPosition);
            }
            LogEntryDescriptor.setKey(writeBuffer, bufferOffset, key);
            LogEntryDescriptor.setTimestamp(writeBuffer, bufferOffset, ActorClock.currentTimeMillis());
            LogEntryDescriptor.setMetadataLength(writeBuffer, bufferOffset, (short)metadataLength);
            if (metadataLength > 0) {
                writeBuffer.putBytes(LogEntryDescriptor.metadataOffset(bufferOffset), (DirectBuffer)this.eventBuffer, this.eventBufferOffset, metadataLength);
                this.eventBufferOffset += metadataLength;
            }
            writeBuffer.putBytes(LogEntryDescriptor.valueOffset(bufferOffset, metadataLength), (DirectBuffer)this.eventBuffer, this.eventBufferOffset, valueLength);
            this.eventBufferOffset += valueLength;
            lastEventPosition = position;
        }
        return lastEventPosition;
    }

    private void resetEvent() {
        this.key = -1L;
        this.sourceIndex = -1;
        this.metadataWriter = this.metadataWriterInstance;
        this.valueWriter = null;
        this.bufferWriterInstance.reset();
        this.metadataWriterInstance.reset();
    }
}

