/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.service;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.DispatcherBuilder;
import io.zeebe.dispatcher.impl.PositionUtil;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.logstreams.spi.LogStorage;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;

public class LogWriteBufferService
implements Service<Dispatcher> {
    private final Injector<LogStorage> logStorageInjector = new Injector();
    protected DispatcherBuilder dispatcherBuilder;
    protected Dispatcher dispatcher;

    public LogWriteBufferService(DispatcherBuilder builder) {
        this.dispatcherBuilder = builder;
    }

    public void start(ServiceStartContext ctx) {
        ctx.run(() -> {
            int partitionId = this.determineInitialPartitionId();
            this.dispatcher = this.dispatcherBuilder.initialPartitionId(partitionId + 1).name(ctx.getName()).actorScheduler(ctx.getScheduler()).build();
        });
    }

    public void stop(ServiceStopContext ctx) {
        ctx.async(this.dispatcher.closeAsync());
    }

    public Dispatcher get() {
        return this.dispatcher;
    }

    private int determineInitialPartitionId() {
        LogStorage logStorage = (LogStorage)this.logStorageInjector.getValue();
        try (BufferedLogStreamReader logReader = new BufferedLogStreamReader();){
            logReader.wrap(logStorage);
            long lastPosition = 0L;
            logReader.seekToLastEvent();
            if (logReader.hasNext()) {
                LoggedEvent lastEntry = logReader.next();
                lastPosition = lastEntry.getPosition();
            }
            int partitionId = 0;
            if (lastPosition > 0L) {
                partitionId = PositionUtil.partitionId((long)lastPosition);
            }
            int n = partitionId;
            return n;
        }
    }

    public Injector<LogStorage> getLogStorageInjector() {
        return this.logStorageInjector;
    }
}

