/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.service;

import io.zeebe.logstreams.impl.log.fs.FsLogStorage;
import io.zeebe.logstreams.impl.log.fs.FsLogStorageConfiguration;
import io.zeebe.logstreams.spi.LogStorage;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import java.io.IOException;
import java.util.function.Function;

public class FsLogStorageService
implements Service<LogStorage> {
    private final FsLogStorageConfiguration config;
    private final int partitionId;
    private final Function<FsLogStorage, FsLogStorage> logStorageStubber;
    private FsLogStorage logStorage;

    public FsLogStorageService(FsLogStorageConfiguration config, int partitionId, Function<FsLogStorage, FsLogStorage> logStorageStubber) {
        this.config = config;
        this.partitionId = partitionId;
        this.logStorageStubber = logStorageStubber;
    }

    public void start(ServiceStartContext startContext) {
        this.logStorage = this.logStorageStubber.apply(new FsLogStorage(this.config));
        startContext.run(this::openLogStorage);
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.run(this.logStorage::close);
    }

    public LogStorage get() {
        return this.logStorage;
    }

    public void openLogStorage() {
        try {
            this.logStorage.open();
        }
        catch (IOException e) {
            this.openLogStorage();
        }
    }
}

