/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.log.fs;

import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.impl.log.fs.FsLogSegmentDescriptor;
import io.zeebe.logstreams.impl.log.fs.Rater;
import io.zeebe.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class FsLogSegment {
    public static final Logger LOG = Loggers.LOGSTREAMS_LOGGER;
    public static final short INVALID_ADDR = -1;
    public static final short NO_DATA = -2;
    public static final short END_OF_SEGMENT = -3;
    public static final short INSUFFICIENT_CAPACITY = -4;
    private static final short STATE_ACTIVE = 1;
    private static final short STATE_FILLED = 2;
    private static final String ERROR_MSG_OUT_OF_SPACE = "Expected to allocate new segment of size %d, but not enough space available (%d)";
    private static final String ERROR_MSG_INSUFFICIENT_CAPACITY = "Expected to append block with size %d, but actual capacity is insufficient %d.";
    private final String fileName;
    protected volatile short state;
    private FileChannel fileChannel;
    private final Rater rater = new Rater(0x400000, () -> {
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    private UnsafeBuffer metadataSection;
    private MappedByteBuffer mappedBuffer;

    public FsLogSegment(String fileName) {
        this.fileName = fileName;
    }

    public boolean openSegment(boolean create) {
        this.fileChannel = FileUtil.openChannel((String)this.fileName, (boolean)create);
        if (this.fileChannel != null) {
            try {
                this.mappedBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, FsLogSegmentDescriptor.METADATA_LENGTH);
                this.metadataSection = new UnsafeBuffer((ByteBuffer)this.mappedBuffer, 0, FsLogSegmentDescriptor.METADATA_LENGTH);
            }
            catch (IOException e) {
                this.fileChannel = null;
                this.metadataSection = null;
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
        return this.fileChannel != null;
    }

    public void closeSegment() {
        if (this.fileChannel.isOpen()) {
            try {
                this.metadataSection = null;
                IoUtil.unmap((MappedByteBuffer)this.mappedBuffer);
                this.fileChannel.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close segment", (Throwable)e);
            }
        }
    }

    public void delete() {
        File file = new File(this.fileName);
        FileUtil.deleteFile((File)file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getSegmentId() {
        return this.metadataSection.getInt(FsLogSegmentDescriptor.SEGMENT_ID_OFFSET);
    }

    private void setSegmentId(int segmentId) {
        this.metadataSection.putInt(FsLogSegmentDescriptor.SEGMENT_ID_OFFSET, segmentId);
    }

    public int getSize() {
        return this.metadataSection.getInt(FsLogSegmentDescriptor.SEGMENT_SIZE_OFFSET);
    }

    int getSizeVolatile() {
        return this.metadataSection.getIntVolatile(FsLogSegmentDescriptor.SEGMENT_SIZE_OFFSET);
    }

    private void setSizeVolatile(int tail) {
        this.metadataSection.putIntVolatile(FsLogSegmentDescriptor.SEGMENT_SIZE_OFFSET, tail);
    }

    private void setSizeOrdered(int tail) {
        this.metadataSection.putIntOrdered(FsLogSegmentDescriptor.SEGMENT_SIZE_OFFSET, tail);
    }

    public int getCapacity() {
        return this.metadataSection.getInt(FsLogSegmentDescriptor.SEGMENT_CAPACITY_OFFSET);
    }

    protected void setCapacity(int capacity) {
        this.metadataSection.putInt(FsLogSegmentDescriptor.SEGMENT_CAPACITY_OFFSET, capacity);
    }

    public boolean isFilled() {
        return this.state == 2;
    }

    public boolean isActive() {
        return this.state == 1;
    }

    public void allocate(int segmentId, int segmentSize) throws IOException {
        File file = new File(this.fileName);
        long availableSpace = FileUtil.getAvailableSpace((File)file.getParentFile());
        if (availableSpace <= (long)segmentSize) {
            throw new IOException(String.format(ERROR_MSG_OUT_OF_SPACE, segmentSize, availableSpace));
        }
        this.openSegment(true);
        this.setSegmentId(segmentId);
        this.setCapacity(segmentSize);
        this.setSizeVolatile(FsLogSegmentDescriptor.METADATA_LENGTH);
    }

    public int append(ByteBuffer block) throws IOException {
        int blockLength = block.remaining();
        int currentSize = this.getSize();
        int remainingCapacity = this.getCapacity() - currentSize;
        if (remainingCapacity < blockLength) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_INSUFFICIENT_CAPACITY, blockLength, remainingCapacity));
        }
        int newSize = currentSize;
        while (newSize - currentSize < blockLength) {
            int writtenBytes = this.fileChannel.write(block, newSize);
            newSize += writtenBytes;
        }
        this.setSizeOrdered(newSize);
        this.rater.mark(blockLength);
        return currentSize;
    }

    public void flush() throws IOException {
        if (this.fileChannel.isOpen()) {
            this.fileChannel.force(false);
        }
    }

    public int readBytes(ByteBuffer readBuffer, int fileOffset) {
        int limit = this.getSizeVolatile();
        int bufferOffset = readBuffer.position();
        int bufferRemaining = readBuffer.remaining();
        int opResult = -1;
        if (fileOffset >= FsLogSegmentDescriptor.METADATA_LENGTH && fileOffset <= limit) {
            int available = limit - fileOffset;
            int bytesToRead = Math.min(bufferRemaining, available);
            if (bytesToRead > 0) {
                readBuffer.limit(bufferOffset + bytesToRead);
                try {
                    opResult = this.fileChannel.read(readBuffer, fileOffset);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read from file " + this.fileName + " at offset: " + fileOffset, e);
                }
            } else if (available == 0) {
                opResult = this.isFilled() ? -3 : -2;
            } else if (bufferRemaining == 0) {
                opResult = -4;
            }
        }
        return opResult;
    }

    public void setFilled() {
        this.state = (short)2;
    }

    public boolean isConsistent() throws IOException {
        int committedSize;
        long currentFileSize = this.fileChannel.size();
        return currentFileSize == (long)(committedSize = this.getSize());
    }

    public void truncateUncommittedData() throws IOException {
        int committedSize = this.getSize();
        this.closeSegment();
        try (FileChannel fileChannel = FileUtil.openChannel((String)this.fileName, (boolean)false);){
            fileChannel.truncate(committedSize);
        }
        this.openSegment(false);
    }
}

