/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.log;

import io.atomix.cluster.MemberId;
import io.zeebe.distributedlog.restore.RestoreClient;
import io.zeebe.distributedlog.restore.log.FailedAppendException;
import io.zeebe.distributedlog.restore.log.InvalidLogReplicationResponse;
import io.zeebe.distributedlog.restore.log.LogReplicationAppender;
import io.zeebe.distributedlog.restore.log.LogReplicationResponse;
import io.zeebe.distributedlog.restore.log.impl.DefaultLogReplicationRequest;
import io.zeebe.util.ZbLogger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class LogReplicator {
    private final LogReplicationAppender appender;
    private final RestoreClient client;
    private final Executor executor;
    private final Logger logger;

    public LogReplicator(LogReplicationAppender appender, RestoreClient client, Executor executor) {
        this(appender, client, executor, (Logger)new ZbLogger(LogReplicator.class));
    }

    public LogReplicator(LogReplicationAppender appender, RestoreClient client, Executor executor, Logger logger) {
        this.appender = appender;
        this.client = client;
        this.executor = executor;
        this.logger = logger;
    }

    public CompletableFuture<Long> replicate(MemberId server, long from, long to) {
        return this.replicate(server, from, to, false);
    }

    public CompletableFuture<Long> replicate(MemberId server, long from, long to, boolean includeFromPosition) {
        CompletableFuture<Long> result = new CompletableFuture<Long>();
        this.replicateInternal(server, from, to, includeFromPosition, result);
        return result;
    }

    private void replicateInternal(MemberId server, long from, long to, boolean includeFromPosition, CompletableFuture<Long> result) {
        DefaultLogReplicationRequest request = new DefaultLogReplicationRequest(from, to, includeFromPosition);
        this.client.requestLogReplication(server, request).whenCompleteAsync((r, e) -> {
            if (e != null) {
                this.logger.debug("Error replicating {} from {}", new Object[]{request, server, e});
                result.completeExceptionally((Throwable)e);
            } else {
                if (!r.isValid()) {
                    this.logger.debug("Received invalid response {} when requesting {} from {}", new Object[]{r, request, server});
                    result.completeExceptionally(new InvalidLogReplicationResponse(server, request, (LogReplicationResponse)r));
                    return;
                }
                if (this.appendEvents(server, from, to, result, (LogReplicationResponse)r)) {
                    if (r.getToPosition() < to && r.hasMoreAvailable()) {
                        this.replicateInternal(server, r.getToPosition(), to, false, result);
                    } else {
                        result.complete(r.getToPosition());
                    }
                }
            }
        }, this.executor);
    }

    private boolean appendEvents(MemberId server, long from, long to, CompletableFuture<Long> result, LogReplicationResponse response) {
        try {
            long appendResult = this.appender.append(response.getToPosition(), response.getSerializedEvents());
            if (appendResult <= 0L) {
                this.logger.debug("Failed to append events from {} - {} with result {}", new Object[]{from, to, appendResult});
                result.completeExceptionally(new FailedAppendException(server, from, to, appendResult));
            }
        }
        catch (RuntimeException error) {
            this.logger.debug("Error when appending events from {} - {}", new Object[]{from, to, error});
            result.completeExceptionally(error);
            return false;
        }
        return true;
    }
}

