/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.impl;

import io.zeebe.distributedlog.restore.RestoreInfoRequest;
import io.zeebe.distributedlog.restore.RestoreInfoResponse;
import io.zeebe.distributedlog.restore.RestoreServer;
import io.zeebe.distributedlog.restore.impl.DefaultRestoreInfoResponse;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreInfo;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.spi.SnapshotController;
import org.slf4j.Logger;

public class DefaultRestoreInfoRequestHandler
implements RestoreServer.RestoreInfoRequestHandler {
    private final SnapshotController snapshotController;
    private final LogStreamReader reader;
    private final LogStream logStream;

    public DefaultRestoreInfoRequestHandler(LogStream logStream, SnapshotController snapshotController) {
        this.logStream = logStream;
        this.reader = new BufferedLogStreamReader(logStream);
        this.snapshotController = snapshotController;
    }

    @Override
    public RestoreInfoResponse onRestoreInfoRequest(RestoreInfoRequest request, Logger logger) {
        DefaultRestoreInfoResponse response = DefaultRestoreInfoResponse.NONE;
        long lastValidSnapshotPosition = this.snapshotController.getLastValidSnapshotPosition();
        logger.debug("Received restore info request {}", (Object)request);
        if (lastValidSnapshotPosition > -1L && lastValidSnapshotPosition >= request.getLatestLocalPosition()) {
            SnapshotRestoreInfo restoreInfo = this.snapshotController.getLatestSnapshotRestoreInfo();
            if (restoreInfo.getSnapshotId() >= request.getLatestLocalPosition() && restoreInfo.getNumChunks() > 0) {
                response = new DefaultRestoreInfoResponse(RestoreInfoResponse.ReplicationTarget.SNAPSHOT, restoreInfo);
            }
        } else if (this.seekToRequestedPositionExclusive(request.getLatestLocalPosition())) {
            response = new DefaultRestoreInfoResponse(RestoreInfoResponse.ReplicationTarget.EVENTS);
        }
        logger.debug("Responding restore info request with {} (snapshot position: {}, log position: {})", new Object[]{response, lastValidSnapshotPosition, this.logStream.getCommitPosition()});
        return response;
    }

    private boolean seekToRequestedPositionExclusive(long position) {
        if (position == -1L) {
            this.reader.seekToFirstEvent();
            return this.reader.hasNext();
        }
        return this.reader.seek(position) && this.reader.hasNext();
    }
}

