/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.impl;

import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.Synchronous;
import io.zeebe.distributedlog.AsyncDistributedLogstream;
import io.zeebe.distributedlog.DistributedLogstream;
import io.zeebe.distributedlog.impl.DistributedLogstreamProxy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingDistributedLogstream
extends Synchronous<AsyncDistributedLogstream>
implements DistributedLogstream {
    private final DistributedLogstreamProxy distributedLogstreamProxy;
    private final long timeout;

    public BlockingDistributedLogstream(DistributedLogstreamProxy distributedLogstreamProxy, long timeout) {
        super((AsyncPrimitive)distributedLogstreamProxy);
        this.distributedLogstreamProxy = distributedLogstreamProxy;
        this.timeout = timeout;
    }

    @Override
    public long append(String partition, String nodeId, long commitPosition, byte[] blockBuffer) {
        try {
            return this.distributedLogstreamProxy.append(partition, nodeId, commitPosition, blockBuffer).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    @Override
    public void claimLeaderShip(String partition, String nodeId, long leaderTerm) {
        try {
            this.distributedLogstreamProxy.claimLeaderShip(partition, nodeId, leaderTerm).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AsyncDistributedLogstream async() {
        return this.distributedLogstreamProxy;
    }
}

