/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog;

import io.zeebe.distributedlog.StorageConfiguration;
import io.zeebe.util.ByteValue;
import io.zeebe.util.FileUtil;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class StorageConfigurationManager
extends Actor {
    private static final String PARTITION_LOG_DIR = "segments";
    private static final String PARTITION_STATES_DIR = "state";
    private final List<StorageConfiguration> configurations = new ArrayList<StorageConfiguration>();
    private final int[] partitionCountPerDataDirectory;
    private final List<String> directories;
    private final String segmentSize;

    public StorageConfigurationManager(List<String> dataDirectories, String segmentSize) {
        this.directories = dataDirectories;
        this.segmentSize = segmentSize;
        this.partitionCountPerDataDirectory = new int[dataDirectories.size()];
    }

    protected void onActorStarting() {
        for (int i = 0; i < this.directories.size(); ++i) {
            this.readConfigurations(this.directories.get(i), i);
        }
    }

    private void readConfigurations(String dataDirectoryName, int offset) {
        File[] partitionDirectories;
        File dataDirectory = new File(dataDirectoryName);
        for (File partitionDirectory : partitionDirectories = dataDirectory.listFiles((d, f) -> new File(d, f).isDirectory())) {
            File logDirectory = new File(partitionDirectory, PARTITION_LOG_DIR);
            File statesDirectory = new File(partitionDirectory, PARTITION_STATES_DIR);
            this.configurations.add(new StorageConfiguration(logDirectory, statesDirectory));
            int n = offset;
            this.partitionCountPerDataDirectory[n] = this.partitionCountPerDataDirectory[n] + 1;
        }
    }

    public ActorFuture<StorageConfiguration> createConfiguration(int partitionId) {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.run(() -> this.lambda$createConfiguration$2(partitionId, (ActorFuture)future));
        return future;
    }

    private int assignDataDirectory() {
        int min = Integer.MAX_VALUE;
        int minOffset = -1;
        for (int i = 0; i < this.partitionCountPerDataDirectory.length; ++i) {
            int partitionCount = this.partitionCountPerDataDirectory[i];
            if (partitionCount >= min) continue;
            min = partitionCount;
            minOffset = i;
        }
        return minOffset;
    }

    public ActorFuture<Void> close() {
        return this.actor.close();
    }

    private /* synthetic */ void lambda$createConfiguration$2(int partitionId, ActorFuture future) {
        Optional<StorageConfiguration> partitionConfig = this.configurations.stream().filter(config -> config.getPartitionId() == partitionId).findAny();
        if (partitionConfig.isPresent()) {
            future.complete((Object)partitionConfig.get());
        } else {
            String partitionName = String.format("partition-%d", partitionId);
            int assignedDataDirOffset = this.assignDataDirectory();
            String assignedDataDirectoryName = this.directories.get(assignedDataDirOffset);
            File partitionDirectory = new File(assignedDataDirectoryName, partitionName);
            try {
                partitionDirectory.mkdir();
                File logDirectory = new File(partitionDirectory, PARTITION_LOG_DIR);
                logDirectory.mkdir();
                File statesDirectory = new File(partitionDirectory, PARTITION_STATES_DIR);
                statesDirectory.mkdir();
                StorageConfiguration storage = new StorageConfiguration(logDirectory, statesDirectory);
                storage.setPartitionId(partitionId).setLogSegmentSize(new ByteValue(this.segmentSize).toBytes());
                this.configurations.add(storage);
                future.complete((Object)storage);
                int n = assignedDataDirOffset;
                this.partitionCountPerDataDirectory[n] = this.partitionCountPerDataDirectory[n] + 1;
            }
            catch (Exception e) {
                try {
                    FileUtil.deleteFolder((String)partitionDirectory.getAbsolutePath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                future.completeExceptionally((Throwable)e);
            }
        }
    }
}

