/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.EventDefinition;
import io.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.zeebe.model.bpmn.instance.StartEvent;
import io.zeebe.model.bpmn.instance.TimerEventDefinition;
import java.util.Collection;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class StartEventValidator
implements ModelElementValidator<StartEvent> {
    public Class<StartEvent> getElementType() {
        return StartEvent.class;
    }

    public void validate(StartEvent element, ValidationResultCollector validationResultCollector) {
        Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
        if (eventDefinitions.size() > 1) {
            validationResultCollector.addError(0, "Start event can't have more than one type");
        } else {
            for (EventDefinition eventDef : eventDefinitions) {
                if (eventDef instanceof TimerEventDefinition || eventDef instanceof MessageEventDefinition) continue;
                validationResultCollector.addError(0, "Start event must be one of the following types: none, timer, message");
            }
        }
    }
}

